#version 330 core

uniform mat4 ProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform float time;

in vec3 velocity[1];
in vec3 params[1];

out vec2 uv;
out vec3 ec_pos;
out float intensity;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;


#define EMIT_VERTEX(VTX, UV) \
	intensity = alpha; \
	uv = UV; \
	ec_pos = VTX; \
	gl_Position = ProjectionMatrix * vec4((VTX), 1.0); \
	EmitVertex()

void main()
{
	float t = (time - params[0].y) * params[0].z;
	if ( t < 0.0 ) return;

	float k  = (1.0 - pow(1.0 - t, 2.0));
	vec3 offset = velocity[0]*k + sin( velocity[0] * t * 8.0 );

	vec3 newPos = gl_in[0].gl_Position.xyz + offset;

	vec4 pos = ModelViewMatrix * vec4(newPos, 1.0);
	float dist = dot(pos.xyz, vec3(0.0, 0.0, -1.0)) - 1.0;
	float alpha = smoothstep(0.0, 1.0, dist);
	alpha *= smoothstep(0.0, 0.2, t) - smoothstep(0.5, 1.0, t);
	if ( alpha <= 0.0 ) return;

	const vec3 XAxis = vec3(1.0, 0.0, 0.0);
	const vec3 YAxis = vec3(0.0, 1.0, 0.0);

	float radius = params[0].x;
	vec3 a = pos.xyz + (XAxis + YAxis)*radius;
	vec3 b = pos.xyz + (YAxis - XAxis)*radius;
	vec3 c = pos.xyz + (-XAxis - YAxis)*radius;
	vec3 d = pos.xyz + (XAxis - YAxis)*radius;

	EMIT_VERTEX(a, vec2(1.0, 0.0));
	EMIT_VERTEX(b, vec2(0.0, 0.0));
	EMIT_VERTEX(d, vec2(1.0, 1.0));
	EMIT_VERTEX(c, vec2(0.0, 1.0));

	EndPrimitive();
}
