#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewProjectionMatrix;
uniform mat3 NormalMatrix;
uniform float lightSize;

layout (location = 0) in vec3 POSITION;

out vec4 light_pos; //x,y,z,size

void main()
{
	light_pos.xyz = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	light_pos.w = lightSize;

	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
