#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform vec3 texCoordScale;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;

out vec2 pos_zw;
out vec3 terrain_normal;
out vec3 normal;
out vec3 ec_pos;
out vec3 uvw;
out vec2 uv;
out float height;

void main()
{
	height = POSITION.y;
	uvw = POSITION*texCoordScale;
	uv = POSITION.xz*(1.0/256.0) + vec2(0.5);
	terrain_normal = NORMAL;
	normal = NormalMatrix * NORMAL;
	ec_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));

	vec4 proj_pos = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
