#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec2 uv;
out vec3 ec_pos;

void main()
{
	vec3 pos = POSITION*2.0;
	uv = TEXCOORD;
	ec_pos = vec3(ModelViewMatrix * vec4(pos, 1.0));
	gl_Position = ModelViewProjectionMatrix * vec4(pos, 1.0);
}
