#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat3 NormalMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec2 uv;
out vec3 normal;

void main()
{
	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}

