#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 WorldMatrix;
uniform mat3 NormalMatrix;
uniform float time;
uniform vec3 texCoordScale;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;

out vec2 pos_zw;
out vec3 terrain_normal;
out vec3 normal;
out vec3 uvw;
out vec2 uv;
out float height;

void main()
{
	float angle = POSITION.x + POSITION.y + POSITION.z;
	vec3 offset = NORMAL* sin(angle*0.125 + time) * 0.5;
	vec4 pos = vec4(POSITION + offset, 1.0);
	vec3 wpos = vec3(WorldMatrix * pos) * 0.05;

	height = wpos.y;
	uvw = wpos*texCoordScale;
	uv = wpos.xz*(1.0/256.0) + vec2(0.5);
	terrain_normal = vec3(WorldMatrix * vec4(NORMAL, 0.0));
	normal = NormalMatrix * NORMAL;

	vec4 proj_pos = ModelViewProjectionMatrix * pos;
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
