#version 330 core

uniform sampler2D normal_depth;
uniform sampler2D diffuse_specular;
uniform sampler2D particle;
uniform vec2 viewport;

in vec2 uv;
in vec3 ec_pos;
in float intensity;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 ds = texture(diffuse_specular, uv_pos);
	vec4 nd = texture(normal_depth, uv_pos);

	vec3 pos = calc_position(uv_pos, nd.w);
	if ( pos.z > ec_pos.z ) discard;

	float alpha = clamp(ec_pos.z - pos.z, 0.0, 1.0);

	vec4 color = texture(particle, uv) * intensity * 0.5;
	//if ( color.a < 0.1 ) discard;

	frag_color.rgb = color.rgb * alpha;
	frag_color.a = 0.0;
}
