#version 330 core

uniform sampler2D color_buffer;
uniform sampler2D dof_buffer;
uniform sampler2D glow_buffer;
uniform sampler2D depth_buffer;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

#include <post/blit_include.frag>

#include <post/dof_include.frag>

void main()
{
	vec2 uv2 = distort_uv(uv);

	vec4 c0 = textureLod(color_buffer, uv2, 0.0);
	vec4 c1 = textureLod(dof_buffer, uv2, 0.0);
	vec4 g = texture2D(glow_buffer, uv2);
	float z = texture2D(depth_buffer, uv2).x;

	float coc = circleOfConfusion(z);

	vec4 c = c0*(1.0 - coc) + c1*coc + g*(1.5 - coc);
	c.a = c0.a;

	frag_color = color_lookup(c, uv);
}
