#version 330 core

uniform sampler2D color_buffer;
uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform sampler2D debug_buffer;
uniform sampler2D ssao_buffer;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

#include <post/blit_include.frag>

float linearizeDepth(in float z)
{
	const float n = 1.0; // camera z near
	const float f = 1024.0; // camera z far
	return (2.0 * n) / (f + n - z * (f - n));
}

void main()
{
#if 0
	vec2 uv2 = distort_uv(uv);
	vec4 color = texture(color_buffer, uv2);
	frag_color = color_lookup(color, uv);
#else
	frag_color = texture(ssao_buffer, uv).aaaa;
	//frag_color.rgb = normalize(texture(normal_depth, uv).rgb)*0.5 + vec3(0.5);
	//frag_color.rgb = vec3(linearizeDepth(texture(normal_depth, uv).a));
	//frag_color.a = 1.0;
	//frag_color = texture(diffuse_specular, uv);
	//frag_color = texture(debug_buffer, uv).aaaa;
	//frag_color.rgb = texture(debug_buffer, uv).rgb;
	//frag_color.rgb = vec3( linearizeDepth(texture(debug_buffer, uv).r) );
	//frag_color.a = 1.0;
#endif
}
