#version 330 core

uniform mat4 WorldMatrix;
uniform mat3 WorldNormalMatrix;
uniform mat3 NormalMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;

out vec4 normal;
out vec3 viewNormal;

void main()
{
	viewNormal = NormalMatrix * NORMAL;

	vec3 wn = WorldNormalMatrix * NORMAL;
	vec3 axis = cross(wn, vec3(0.0, 1.0, 0.0));
	normal.xyz = axis;
	normal.w = dot(axis, wn);
	//normal = WorldNormalMatrix * NORMAL;
	gl_Position = WorldMatrix * vec4(POSITION, 1.0);
}
