#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ProjectionMatrix;
uniform mat3 NormalMatrix;

in vec4 gs_normal[1];

out vec3 ec_pos;
out vec2 pos_zw;
out vec2 uv;

layout(points) in;
layout(triangle_strip, max_vertices = 24) out;

#define USE_CUBES

#define EMIT_VERTEX(VTX, UV) \
	uv = UV; \
	ec_pos = VTX; \
	gl_Position = ProjectionMatrix * vec4(VTX, 1.0); \
	pos_zw = gl_Position.zw; \
	EmitVertex()

#define MAKE_QUAD(A, B, C, D) \
	EMIT_VERTEX(view[A], vec2(1.0, 0.0)); \
	EMIT_VERTEX(view[B], vec2(0.0, 0.0)); \
	EMIT_VERTEX(view[D], vec2(1.0, 1.0)); \
	EMIT_VERTEX(view[C], vec2(0.0, 1.0)); \
	EndPrimitive()

#define MAKE_TRIANGLE(A, B, C) \
	EMIT_VERTEX(view[A], vec2(1.0, 0.0)); \
	EMIT_VERTEX(view[B], vec2(0.0, 0.0)); \
	EMIT_VERTEX(view[C], vec2(0.0, 1.0)); \
	EndPrimitive()

#ifdef USE_CUBES
vec3 cube_vertices[8] = vec3[](
	vec3( 1.0,  1.0, -1.0),
	vec3(-1.0,  1.0, -1.0),
	vec3(-1.0, -1.0, -1.0),
	vec3( 1.0, -1.0, -1.0),
	vec3( 1.0,  1.0,  1.0),
	vec3(-1.0,  1.0,  1.0),
	vec3(-1.0, -1.0,  1.0),
	vec3( 1.0, -1.0,  1.0)
);

#else
vec3 tetrahedron_vertices[4] = vec3[](
	vec3(-0.269, -0.5, -0.5),
	vec3( 0.598, -0.5, 0.0),
	vec3(-0.269, -0.5, 0.5),
	vec3(0.0, 0.5, 0.0)
);
#endif

void rotate_around_axis(in vec3 axis, in float angle, out mat3 mr)
{
	float c = cos(angle);
	float s = sin(angle);
	float one_minus_c = 1.0 - c;

	mr[0].x = c + one_minus_c*axis.x*axis.x;
	mr[0].y = axis.x*axis.y*one_minus_c - axis.z*s;
	mr[0].z = axis.x*axis.z*one_minus_c + axis.y*s;

	mr[1].x = axis.x*axis.y*one_minus_c + axis.z*s;
	mr[1].y = c + one_minus_c*axis.y*axis.y;
	mr[1].z = axis.y*axis.z*one_minus_c - axis.x*s;

	mr[2].x = axis.x*axis.z*one_minus_c - axis.y*s;
	mr[2].y = axis.y*axis.z*one_minus_c + axis.x*s;
	mr[2].z = c + one_minus_c*axis.z*axis.z;
}

void main()
{
	float size = gl_in[0].gl_Position.w;
	vec3 center = gl_in[0].gl_Position.xyz;

#ifdef USE_CUBES
	vec3 view[8];
	for (int i=0; i < 8; i++)
	{
		//vec3 offset = mr * (cube_vertices[i] * size);
		vec3 offset = cube_vertices[i] * size;
		vec4 pos = vec4(center + offset, 1.0);
		view[i] = vec3(ModelViewMatrix * pos);
	}

	MAKE_QUAD(3,2,1,0);
	MAKE_QUAD(4,5,6,7);
	MAKE_QUAD(6,5,1,2);
	MAKE_QUAD(7,3,0,4);
	MAKE_QUAD(5,4,0,1);
	MAKE_QUAD(7,6,2,3);
#else
	mat3 mr;
	rotate_around_axis(gs_normal[0].xyz, gs_normal[0].w, mr);
	vec3 view[4];
	for (int i=0; i < 4; i++)
	{
		vec3 offset = mr * (tetrahedron_vertices[i] * size*4.0);
		vec4 pos = vec4(center + offset, 1.0);
		view[i] = vec3(ModelViewMatrix * pos);
	}
	MAKE_TRIANGLE(0,1,2);
	MAKE_TRIANGLE(0,2,3);
	MAKE_TRIANGLE(0,3,1);
	MAKE_TRIANGLE(1,3,2);
#endif
}
