
uniform mat4 objectMatrix;

varying vec3 viewRay;
varying mat3 lightRot;

mat3 mat3_emu(mat4 m4) {
  return mat3(
      m4[0][0], m4[0][1], m4[0][2],
      m4[1][0], m4[1][1], m4[1][2],
      m4[2][0], m4[2][1], m4[2][2]);
}

void main( void )
{
	viewRay = (gl_ModelViewMatrix * gl_Vertex).xyz;
	lightRot = mat3_emu(objectMatrix) * mat3_emu(gl_ModelViewMatrixInverse);
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
}
