#include version.txt
#include brightness_contrast.txt

uniform sampler2D image;
uniform float image_size;
uniform sampler1D distortmap;
uniform float distort_amount;
uniform float distort_scroll;
uniform float aberration;
uniform float brightness;
uniform float contrast;
uniform float negative;
uniform float fade;
uniform vec3 fade_color;
uniform float vignett_radius;
uniform sampler2D noise;
uniform float noise_offset;
uniform float noise_strength;

void main() {

  // Distort
	float offset = texture1D(distortmap, gl_TexCoord[0].y).r;
	float offset2 = ((texture1D(distortmap, gl_TexCoord[0].y + distort_scroll + offset).r * 2.0) - 1.0) * distort_amount;


	// Chromatic Aberration	
  float step = (1.0 / image_size) * aberration;
	step *= sqrt(pow(gl_TexCoord[0].x - 0.5, 2.0) + pow(gl_TexCoord[0].y - 0.5, 2.0));
	float r  = texture2D(image, gl_TexCoord[0].xy + step + vec2(offset2, 0.0)).r;
	float g  = texture2D(image, gl_TexCoord[0].xy + (step * 2.0) + vec2(offset2, 0.0)).g;
	float b  = texture2D(image, gl_TexCoord[0].xy + (step * 3.0) + vec2(offset2, 0.0)).b;
  vec4 fragment = vec4(r, g, b, 1.0);
  
    
  // Brightness & Contrast
	fragment = brightnessContrast(fragment, brightness, contrast);

	
	// Negativ
	vec4 neg = 1.0 - fragment;
	fragment = mix(fragment, neg, negative);

	
	// Vignett
	float x = gl_TexCoord[0].x - 0.5;
	float y = gl_TexCoord[0].y - 0.5;
	float v = (sqrt(pow(x, 2.0) + pow(y, 2.0))) * vignett_radius;
	fragment = fragment - vec4(v, v, v, 0.0);
	
	
	// Noise
	r = mod((texture2D(noise, gl_TexCoord[0].xy) + noise_offset).r * 15.0, 1.0);
	g = mod((texture2D(noise, gl_TexCoord[0].xy) + noise_offset + 0.5).g * 15.0, 1.0);
	b = mod((texture2D(noise, gl_TexCoord[0].xy) + noise_offset - 0.75).b * 15.0, 1.0);
  vec4 noise_value = vec4(r, g, b, 1.0);
  fragment = fragment + (vec4(1.0) - fragment) * (noise_value * noise_strength);    
	
	
  // Fade
	gl_FragColor = mix(fragment, vec4(fade_color, 1.0), fade);
}
