uniform sampler2D values;
uniform vec4 background_color;
uniform vec4 foreground_color;
uniform vec2 scale;
uniform float MaterialIndex;

varying vec3 normals;

void main() 
{
	float x = mod(gl_TexCoord[0].x * scale.x, 1.0);
	float y = mod(gl_TexCoord[0].y * scale.y, 1.0);

	float v = 1.0 - texture2D(values, vec2(gl_TexCoord[0].x, 0.0)).r;
	v = ceil(v * scale.y);
	float ycoord = ceil((1.0 - gl_TexCoord[0].y) * scale.y);

	if(x > 0.1 && x < 0.9 && y > 0.2 && y < 0.8 && ycoord > v) 
	{
		gl_FragData[0] = vec4(foreground_color.rgb, 255.0 / 255.0);
	}
	else 
	{
		gl_FragData[0] = vec4(vec3(0.0, 0.0, 1.0), MaterialIndex/255.0);
	}

	gl_FragData[1] = vec4(normalize(normals.xyz), 0.0); // normals	
}
