
uniform sampler2D spotTexture;
uniform sampler2D diffuseBuffer;
uniform sampler2D depthBuffer;
uniform sampler2D normalBuffer;
uniform sampler2D materialBuffer;

uniform vec2 ProjConst; // Projection constants depth
uniform float lightRadius;
uniform vec3 lightPos;
uniform vec4 color;
uniform vec2 screensize;

uniform vec3 lightDirection;
uniform float FallOff;
uniform float LinearAttenuation;

varying vec3 viewRay;
varying mat4 viewM;

float ReadSurfaceMaterial(in vec2 uv, out vec4 specular)
{
	float matIndex = texture2D(diffuseBuffer, uv).a * 255.0 + 1.0;
	float dx = 1.0 / 8.0;   // width * 2
	float dy = 1.0 / 512.0; // heght * 2
	specular        = texture2D( materialBuffer, vec2(dx * (2.0 * 2.0 - 1.0), dy * (matIndex * 2.0 - 1.0)) );
	float shininess = texture2D( materialBuffer, vec2(dx * (3.0 * 2.0 - 1.0), dy * (matIndex * 2.0 - 1.0)) ).r * 255.0;
	return shininess;
}

void main( void )
{
	vec2 uv = vec2(gl_FragCoord.x / screensize.x, gl_FragCoord.y / screensize.y);
	// color
	vec4 colorPass = texture2D(diffuseBuffer, uv);
	// Normal
	vec4 gnormal = texture2D(normalBuffer, uv);	
	vec3 normal = normalize(gnormal.xyz);
	
	// View position reconstruct
	float depth = texture2D(depthBuffer, uv).r;
	vec3 ray = vec3(viewRay.xy / -viewRay.z, -1.0);
	float linearDepth = ProjConst.y  / (depth - ProjConst.x);
	vec3 point = ray * linearDepth;
	
	vec3 light_norm = normalize(point - lightPos);
	float len = length(point - lightPos);
	// Separate what's inside the cone volume
	float ndl = dot(lightDirection, light_norm);
	if(ndl > FallOff)
	{
		// What fragments are lit by the light volume
		float ndlm = dot(normal, -light_norm);
		if(ndlm > 0.0)
		{
			float lightDistance = length(point - lightPos);
			// Phong
			vec3 reflectV = 2.0 * normal * ndlm + light_norm;
			float ldr = max(dot(reflectV, -normalize(point) ), 0.0);
			// materials
			vec4 specular;
			float shininess = ReadSurfaceMaterial(uv, specular);
			float att = smoothstep(FallOff, 1.0, ndl) * min(1.0, (1.0 - len / lightRadius * LinearAttenuation));
			gl_FragColor = ((colorPass * color * ndlm) + color * specular * pow(ldr, shininess) ) //* att 
			* (texture2D(spotTexture, ((viewM * vec4(point, 1.0) * 1.1).xy * lightRadius/len ) + 0.5));
		}
		else discard; // gl_FragColor = vec4(0.0, 1.0, 0.0, 1.0);// Overdraw
	}
	else discard; //gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0); // Should be culled by stencil test
}

