varying vec2 Texcoord;

uniform sampler2D diffuseMap;
uniform sampler2D lightMap;
uniform sampler2D materialBuffer;
uniform sampler2D depthBuffer;

void main( void )
{

  float z = texture2D(depthBuffer, Texcoord).r;
  float depth = (2.0 * 1.0) / (80.0 + 1.0 - z * (80.0 - 1.0));

	if(depth >= 1.0) 
	{
        gl_FragColor = vec4(1.0);
	}
	else 
	{ 
    vec4 diffuse = texture2D(diffuseMap, Texcoord);
    float matIndex = diffuse.a * 255.0 + 1.0;
    float dx = 1.0 / 8.0;   // width * 2
    float dy = 1.0 / 512.0; // heght * 2
    vec4 combineParams = texture2D( materialBuffer, vec2(dx * (1.0 * 2.0 - 1.0), dy * (matIndex * 2.0 - 1.0)) );	
    float fog = clamp(depth - 0.25, 0.0, 4.0) * 4.0;
		gl_FragColor = combineParams.r * diffuse + texture2D(lightMap, Texcoord) * combineParams.g + fog;
	}
}
