varying vec2 Texcoord;

uniform sampler2D diffuseMap;
uniform sampler2D lightMap;
uniform sampler2D materialBuffer;

void main( void )
{
	vec4 diffuse = texture2D(diffuseMap, Texcoord);
	float matIndex = diffuse.a * 255.0 + 1.0;
	float dx = 1.0 / 8.0;   // width * 2
	float dy = 1.0 / 512.0; // heght * 2
	vec4 combineParams = texture2D( materialBuffer, vec2(dx * (1.0 * 2.0 - 1.0), dy * (matIndex * 2.0 - 1.0)) );
	
    gl_FragColor = combineParams.r * diffuse + texture2D(lightMap, Texcoord) * combineParams.g;
}
