I = (S = Uno.Audio.Channel = function(filename, loop) {
    this.stopped = false;
    this.audio = new Audio(filename);
    this.audio.loop = loop;
    this.audio.play();
}).prototype;

I.Position = function(value) {
    if (value !== undefined) this.audio.currentTime = value;
    return this.audio.currentTime;
}

I.Pan = function(value) {
    return 0.0;
}

I.Volume = function(value) {
    if (value !== undefined) this.audio.volume = value;
    return this.audio.volume;
}

I.Pause = function(value) {
    if (value !== undefined) value ? this.audio.pause() : this.audio.play();
    return this.audio.paused;
}

I.IsPlaying = function() {
    return !this.audio.seeking && !this.audio.paused && !this.audio.ended;
}

I.IsFinished = function() {
    return this.stopped || this.audio.ended;
}

I.Stop = function() {
    this.audio.pause();
    this.stopped = true;
}
