alias demo {
    unset %dm.fullscreen
    if ($1 == fs) {
        set %dm.fullscreen 1
    }
    noop $dmInit(@demo, 0 0 320 180)
    if ($hget(demo) != $null) {
        hfree demo
    }
    hmake demo 20
    ;;-- init
    if ($window(@precalc) != $null) {
        window -c @precalc
    }
    window -lh @precalc
    filter -fw $qt($scriptdirprecalc.dss) @precalc
    hadd demo preclc_cnt 1
    hadd demo preclc_tot $line(@precalc, 0)
    hadd demo preclc_ctab 1118481 2236962 3355443 4473924 5592405 6710886 7829367 8947848 10066329 11184810 12303291 13421772 14540253 15658734 16777215 15658734 14540253 13421772 12303291 11184810 10066329 8947848 7829367 6710886 5592405 4473924 3355443 2236962
    hadd demo preclc_cfc 1
    demo_part_001_init
    ;$+(demo_part_,$1,_init) | $+(demo_part_,$1)
}

alias demo_part_001_init {
    var %cnt 1
    var %t 5
    while (%cnt <= %t) {
        var %read $($line(@precalc, $hget(demo, preclc_cnt)), 2)
        %read
        :error
        hinc demo preclc_cnt
        inc %cnt
    }
    var %colour $gettok($hget(demo, preclc_ctab), $hget(demo, preclc_cfc), 32)
    drawtext -nr   @demo %colour "Lucida Console" 9 8 72 20% cooler...
    drawtext -nr   @demo %colour "Lucida Console" 9 207 100 ...In 10 seconds flat
    var %pct $calc(($hget(demo, preclc_cnt) / $hget(demo, preclc_tot)) * 100)
    drawrect -nir  @demo 0 1 8 82 304 16
    drawrect -nirf @demo 0 1 10 84 $calc($+(0.,$iif(%pct < 10, $+(0,%pct), %pct)) * 300) 12
    if ($hget(demo, preclc_cfc) < $numtok($hget(demo, preclc_ctab), 32)) {
        hinc demo preclc_cfc 0.5
    }
    else {
        hadd demo preclc_cfc 1
    }
    drawdot @demo
    if (%dm.fullscreen == 1) {
        drawcopy @demo 0 0 %dm.cs_w %dm.cs_h @demo2 0 0 %dm.fs.w %dm.fs.h
    }
    drawrect -nrf @demo 0 0 1 0 0 %dm.cs_w %dm.cs_h
    if ($hget(demo, preclc_cnt) > $hget(demo, preclc_tot)) {
        set %dm.music $scriptdirdemotune6.wav
        splay -w $qt(%dm.music)
        signal -n part_select 001
        return
    }
    else {
        .timer -mh 1 0 demo_part_001_init
    }
}

alias demo_part_001 {       
    if ($inwave(%dm.music).pos < 3000) {
        var %text DIGITALSOUNDSSYSTEM
    }
    elseif ($inwave(%dm.music).pos < 6000) {
        var %text PRESENTS
    }
    elseif ($inwave(%dm.music).pos < 9000) {
        var %text A NEW DEMO
    }
    elseif ($inwave(%dm.music).pos < 12000) {
        var %text AT REVISION 2012
    }
    elseif ($inwave(%dm.music).pos < 15000) {
        var %text WE CALL IT
    }
    elseif ($inwave(%dm.music).pos < 18000) {
        var %text RAVE
    }
    elseif ($inwave(%dm.music).pos < 21000) {
        var %text ENJOY THE RIDE
    }
    else {
        var %text
    }
    var %sin $calc(($cos($calc((%c * 1.875) + 180)).deg * 9) + 10)
    ;echo -s 
    var %fsize $calc(2 + %sin)
    var %x $calc(%dm.center_x - (($len(%text) * %fsize) / 2) - %sin)
    var %y $calc((%dm.center_y - 12) - %sin)
    ;; draw bitmap font
    var %count 1
    var %total $len(%text)
    while (%count <= %total) {
        var %chr $right($left(%text, %count), 1)
        var %pos $calc((%x + (%count * %fsize)) - (%fsize / 2))
        if (%chr != $chr(32)) {
            drawpic -nrtcsm @demo 0 %pos %y $calc(%fsize + %sin) $calc(%fsize + %sin) $qt($+($scriptdirimg\chr\01\,%chr,.gif))
        }
        inc %count
    }
    var %col $calc(%sin * 13.4)
    drawreplace -nr @demo 16777215 $rgb(%col, %col, %col)
    if ($inwave(%dm.music).pos > 22500) {        
        var %cnt $hget(demo, part001_fc)
        drawpic -ntsc @demo 0 0 0 320 180 $qt($+($scriptdirimg\louder_raw\,%cnt,.png))
        if (%cnt < 34) {
            hinc demo part001_fc
        }
    }
    if ($inwave(%dm.music).pos < 24000) {
        noop $dmDrawFrame(demo_part_001)
    }
    else {
        signal -n part_select 002
    }
}

alias demo_part_002 {
    if ($inwave(%dm.music).pos > $hget(demo, part002_sync)) {        
        hadd demo part002_mc_01 $gettok($hget(demo, part002_mc_01_tab), $hget(demo, part002_mc_offset), 32)
        hadd demo part002_mc_02 $gettok($hget(demo, part002_mc_02_tab), $hget(demo, part002_mc_offset), 32)
        if ($hget(demo, part002_mc_offset) == $numtok($hget(demo, part002_mc_01_tab), 32)) {
            hadd demo part002_mc_offset 0
        }
        hinc demo part002_mc_offset
        hinc demo part002_sync 375
    }
    var %c1 $hget(demo, part002_mc_01)
    var %c2 $hget(demo, part002_mc_02)
    var %x1 $calc(($cos($calc(%c * 2.7)).deg * 64) + %dm.center_x)
    var %y1 $calc(($sin($calc(%c * 3.3)).deg * 64) + %dm.center_y)
    var %x2 $calc(($cos($calc(%c * 1.9)).deg * 64) + %dm.center_x)
    var %y2 $calc(($sin($calc(%c * 1.2)).deg * 64) + %dm.center_y)
    var %count 1
    while (%count <= 32) {
        drawdot -nri @demo %c1 $calc(%count * 8) %x1 %y1
        drawdot -nri @demo %c2 $calc(%count * 8) %x2 %y2
        inc %count
    }
    var %c = %c * 4
    var %x $calc(%dm.center_x - ($width(AWWWW, fixedsys, 48) / 2))
    if ($inwave(%dm.music).pos > 46500) {        
        drawtext -nr @demo 0 fixedsys 48 $calc(%x + 2) 2   AW
        drawtext -nr @demo 16777215 fixedsys 48 %x 0   AW
    }
    if ($inwave(%dm.music).pos > 46688) {        
        drawtext -nr @demo 0 fixedsys 48 $calc(%x + 2) 2   AWW
        drawtext -nr @demo 16777215 fixedsys 48 %x 0   AWW
    }
    if ($inwave(%dm.music).pos > 46875) {        
        drawtext -nr @demo 0 fixedsys 48 $calc(%x + 2) 2   AWWW
        drawtext -nr @demo 16777215 fixedsys 48 %x 0   AWWW
    }
    if ($inwave(%dm.music).pos > 47063) {        
        drawtext -nr @demo 0 fixedsys 48 $calc(%x + 2) 2   AWWWW
        drawtext -nr @demo 16777215 fixedsys 48 %x 0   AWWWW
    }
    if ($inwave(%dm.music).pos > 47250) {
        drawtext -nr @demo 0 fixedsys 48 $calc(%x + 2) 102 YEAH!
        drawtext -nr @demo 16777215 fixedsys 48 %x 100 YEAH!
    }
    if ($inwave(%dm.music).pos < 48000) {
        noop $dmDrawFrame(demo_part_002)
    }
    else {
        .signal -n part_select 003
    }
}

alias demo_part_003 {
    drawrect -nrf @demo 2631720 0 0 0 320 140
    var %count 1    
    while (%count <= 24) {
        var %x $calc(($cos($calc((%c * 0.7) + (%count * 15))).deg * ($sin($calc(%c * 2.1)).deg * 64)) + %dm.center_x)   
        var %y $calc(($sin($calc((%c * 0.3) + (%count * 15))).deg * ($cos($calc(%c * 1.2)).deg * 64)) + 72)
        drawdot -nr @demo 11842740 2 %x %y $calc(%x + 64) %y $calc(%x - 64) %y $calc(%x + 128) %y $calc(%x - 128) %y
        inc %count
    }
    var %txt $hget(demo, part003_text)
    var %xmain $hget(demo, part003_xpos)
    var %cnt $hget(demo, part003_cpos)
    var %tot $len(%txt)
    while (%cnt <= %tot) {
        var %xpos $calc(%xmain + (%cnt * 24))
        if (%xpos < 320) {
            if (%xpos > -25) {
                var %chr $right($left(%txt, %cnt), 1)
                if (%chr != $chr(32)) {                                        
                    drawtext -nr @demo 16777215 fixedsys 32 %xpos 145 %chr
                }
            }
            else {
                hinc demo part003_cpos
            }
        }
        else {
            break
        }
        inc %cnt
    }
    hdec demo part003_xpos 5.5
    var %count 1
    while (%count <= 39) {
        drawline -nri @demo 11842740 1 0 $calc(140 + %count) 320 $calc(140 + %count)
        inc %count 2
    }
    if ($inwave(%dm.music).pos > 70500) {
        drawrect -nrf @demo 0 0 0 0 320 180
        var %text $+($chr(40),Pause for dramatic effect,$chr(41))
        var %x $calc(%dm.center_x - ($width(%text, fixedsys, 12) / 2))
        drawtext -nr  @demo 16777215 fixedsys 12 %x 80 %text
    }
    if ($inwave(%dm.music).pos > 72000) {
        .signal -n part_select 004 
    }
    else {        
        noop $dmDrawframe(demo_part_003)
    }
}

alias demo_part_004 {
    var %line $hget(demo, part004_picline)    
    drawpic -nsc @demo 0 0 %line 180 0 0 %line 180 $qt($scriptdirimg\osci1.png)
    drawpic -nsc @demo %line 0 320 180 %line 0 1 180 $qt($scriptdirimg\osci1.png)
    if (%line < 320) {
        hinc demo part004_picline 0.5
    }
    ;; dycp
    var %txt $hget(demo, part004_text)
    var %xmain $hget(demo, part004_xpos)
    var %cnt $hget(demo, part004_cpos)
    var %tot $len(%txt)
    var %c = %c * 4
    while (%cnt <= %tot) {
        var %xpos $calc(%xmain + (%cnt * 24))
        if (%xpos < 320) {
            if (%xpos > -25) {
                var %chr $right($left(%txt, %cnt), 1)
                var %y $calc(($cos($calc(%c + (%cnt * 16))).deg * 64) + (%dm.center_y - 16))
                drawtext -nr @demo 0 fixedsys 32 %xpos $calc(%y + 1) %chr
                drawtext -nr @demo 16777215 fixedsys 32 %xpos %y %chr
            }
            else {
                hinc demo part004_cpos
            }
        }
        else {
            break
        }
        inc %cnt
    }
    hdec demo part004_xpos 4
    if ($inwave(%dm.music).pos > 96000) {
        .signal -n part_select 005
    }
    else {
        noop $dmDrawFrame(demo_part_004)
    }
}

alias demo_part_005 {
    var %cnt 1
    while (%cnt <= 5) {
        var %x $calc((($cos($calc((%c * 2) + (%cnt * 90))).deg * 32)) + (($cos(%c).deg * 96) + %dm.center_x))
        var %y $calc((($sin($calc((%c * 2) + (%cnt * 90))).deg * ($cos(%c).deg * 16))) + (($cos($calc(%c * 1.5)).deg * 32) + (%dm.center_y - 20)))
        drawline -nr @demo 16777215 2 %x %y %xo %yo
        drawline -nr @demo 16777215 2 %x $calc(%y + 40) %xo $calc(%yo + 40)
        drawline -nr @demo 16777215 2 %x %y %x $calc(%y + 40)
        var %xo %x
        var %yo %y
        inc %cnt
    }
    drawrect -nrfi @demo 3289650 0 100 0 230 180
    ;; upscroll
    var %count $hget(demo, part005_line)
    var %ypos $hget(demo, part005_ypos)
    while (%count <= 22) {
        var %y $calc(%ypos + (%count * 24))
        if (%y < 180) {
            if (%y > -12) {
                var %txt $hget(demo, $+(part005_text_,%count))
                if (%txt != ~) {
                    var %x $calc(100 - $width(%text, fixedsys, 12) / 2)  
                    drawtext -nr @demo 16777215 fixedsys 12 $calc(%x + 1) $calc(%y + 1) %txt
                    drawtext -nr @demo 0 fixedsys 12 %x %y %txt
                }
            }
            else {
                hinc demo part005_line 
            }
        }
        else {
            break
        }
        inc %count
    }
    if ($hget(demo, part005_ypos) > -432) {
        hdec demo part005_ypos
    }
    noop $dmDrawFrame(demo_part_005)
}

on *:KEYDOWN:*:*: {
    if ($keyval == 49) {
        hadd demo part002_mc_01 $rand(0, 16777215)
        hadd demo part002_mc_02 $rand(0, 16777215)
    }
    elseif ($keyval == 50) {
        echo -a -------
        echo -a $hget(demo, part002_mc_01)
        echo -a $hget(demo, part002_mc_02)
    }
}

on *:SIGNAL:part_select: {
    echo -s $time
    ;$+(demo_part_,$1,_init)
    $+(demo_part_,$1)
}

alias dmDrawFrame {
;    drawtext -nrb @demo 16777215 0 fixedsys 12 0 0 fps: %#
    inc %c
    if ((%% == %$) || ($ticks >= %!)) {
        set %!       $calc($ticks + 1000)
        set %#         %%
        set %%   0
    }
    drawdot @demo
    if (%dm.fullscreen == 1) {
        drawcopy @demo 0 0 %dm.cs_w %dm.cs_h @demo2 0 0 %dm.fs.w %dm.fs.h
    }
    drawrect -nrf @demo 0 0 0 0 %dm.cs_w %dm.cs_h
    ;;
    inc %%    
    .timerdmDrawFrame -mh 1 $calc(%$ - ($ticks - %+)) noop $!dmStartDraw( $1 )    
    return
    :error
    unset %dm.*
    splay stop
}

on *:CLOSE:@demo: {
    splay stop
}

alias dmStartDraw {
    set %+ %-
    $1
}

alias dmInit {
    var %win $1
    var %params $2-
    window -dak0pfBbo $1 $2-
    if (%dm.fullscreen == 1) {
        if ($window(@demo2) == $null) {
            set %dm.fs.w $window(-1).w
            set %dm.fs.h $window(-1).h
            window -dak0pfBbo +d @demo2 -1 -1 %dm.fs.w %dm.fs.h
        }
    }
    set %dm.cs_w $gettok($2, 3, 32)
    set %dm.cs_h $gettok($2, 4, 32)
    set %dm.center_x $calc(%dm.cs_w / 2)
    set %dm.center_y $calc(%dm.cs_h / 2)
    set %- 0
    ;; Configure demo system below. If you don't know what's what, don't touch it.
    ;; dm.ticks
    set %!       %-
    ;; dm.fps
    set %#         0
    ;; dm.fps_target
    set %$  60
    ;; dm.fps_count
    set %%   60
    ;; dm.frt_count
    set %&   1000
    ;; dm.frt_target
    set %'  $calc(1000 / %$)
    ;; dm.frt_start
    set %+   %-
    ;; dm.c
    set %c           1
    ;; end of configuration
}