/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package demoplatform.scenes;

import demoplatform.Demoplatform;
import demoplatform.Distort;
import demoplatform.Metaball;
import demoplatform.Rotozoomer;
import demoplatform.Snow;
import java.awt.Graphics;
import org.dvb.ui.DVBBufferedImage;

/**
 *
 * @author Luis
 */
public class Hypnotoad extends Demoplatform implements Runnable {

    private Thread thread;
    public boolean ready = false;
    private boolean running = false;
    DVBBufferedImage bufferImg = null;
    DVBBufferedImage buffer = null;
    DVBBufferedImage bufferTemp = null;

    // list of effects used
    Rotozoomer rotozoomerEffect;
    Metaball metaballEffect;
    Snow snowEffect;
    Distort distortEffect;

    /* toad vars */
    float toadx = 0;
    float toady = -540;
    float toadeasing = 0.2f;
    int renderBuffer[];
    int[] renderBufferTemp[];  //performance hit

    int[] wubs = {
        79880,
        80316,
        100000
    };
    int wubCounter = 0;

    public boolean ready() {
        return ready;
    }

    public void load() {
        start();
    }

    public void start() {
        debug("Hypnotoad():: thread start");
        thread = new Thread(this);
        thread.start();
    }

    // run in a thread - time consuming stuff here
    public void run() {
        bufferImg = new DVBBufferedImage(w, h, DVBBufferedImage.TYPE_ADVANCED);
        buffer = new DVBBufferedImage(rw, rh, DVBBufferedImage.TYPE_ADVANCED);
        bufferTemp = new DVBBufferedImage(100, 100, DVBBufferedImage.TYPE_ADVANCED);

        bufferImg.setRGB(0, 0, w, h, getImageArray("/images/hypno.png"), 0, w);

        renderBuffer = new int[rw * rh];
        rotozoomerEffect = new Rotozoomer();

        metaballEffect = new Metaball(100, 100);
        bufferTemp = new DVBBufferedImage(100, 100);
        renderBufferTemp = new int[2][];
        renderBufferTemp[0] = getImageArray("/images/obey_joke_wurst.png");
        renderBufferTemp[1] = new int[100 * 100];
        distortEffect = new Distort();
        snowEffect = new Snow();

        ready = true;
    }

    public void draw(Graphics buffer2Graphics, int compareTime) {
        rotozoomerEffect.draw(compareTime, renderBuffer);
        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);

        if (compareTime > 66454) {
            float targetX = 0;
            float targetY = 0;
            float dx = targetX - toadx;
            float dy = targetY - toady;

            if (Math.abs(dx) > 1) {
                toadx += dx * toadeasing;
            }
            if (Math.abs(dy) > 1) {
                toady += dy * toadeasing;
            }
        }

        if (compareTime > 79419) {
            if (compareTime > wubs[wubCounter]) {
                distortEffect.jump = 6;  // distort on wub
                wubCounter++;
            }

            if (compareTime > 81325) {
                distortEffect.jump = 6;  // distort on wub
            }

            if (compareTime > 81583) {
                snowEffect.draw(renderBuffer);
                distortEffect.draw(renderBuffer, renderBuffer, 3);
                renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
            } else {
                distortEffect.draw(renderBuffer, renderBufferTemp[0], 1); //obey
                renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
            }
        } else {
            rotozoomerEffect.draw(compareTime, renderBuffer);
            renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
            buffer2Graphics.drawImage(bufferImg, (int) toadx, (int) toady, w, h, null);  // draw toad
            //buffer2Graphics.drawImage(bufferImage, (int) toadx, (int) toady, w, h, null);  // draw toad

            metaballEffect.draw(renderBufferTemp[1]);
            renderBuffer(renderBufferTemp[1], 100, 100, 167, 19 + (int) toady, 100, 100, bufferTemp, buffer2Graphics);
            renderBuffer(renderBufferTemp[1], 100, 100, 337, 5 + (int) toady, 100, 100, bufferTemp, buffer2Graphics);
        }
    }
}
