/*

 Name      :  Twister
 Notes     :  mandatory twister effect.
 
 references:
 Ferris' blackberry twister effect decompiled then reassembled in less elegant form
 
 */
package demoplatform;

import demoplatform.GL.MathFP;

public class Twister extends Demoplatform {

  int[] textureImg;
  int[] textureImgB;
  int framebuffer[];
  int sintab[];
  int costab[];
  int framec1;
  int framec2;
  int framec3;

  // constructor
  public Twister() {
    debug("Twister():: initialize");
    sintab = new int[256];
    costab = new int[256];
    framec1 = framec2 = framec3 = 0;
    textureImg = getImageArray("/images/twister/logo.png");
    textureImgB = getImageArray("/images/twister/java.png");

    for (int i = 0; i < 256; i++) {
      sintab[i] = (int) (Math.sin(i / 256.0 * Math.PI * 2) * 127 + 127);
      costab[i] = (int) (Math.cos(i / 256.0 * Math.PI * 2) * 127 + 127);
    }
    debug("Twister():: end initialize");
  }

  int adjustBright(int texture, int bright) {
    int rr, gg, bb;

    // disassemble pixel using bit mask to remove color components for greater speed
    rr = texture >> 16 & 0xFF;  // equivalent to red(currentPixel);
    gg = texture >> 8 & 0xFF;   // equivalent to green(currentPixel);
    bb = texture & 0xFF;        // equivalent to blue(currentPixel);

    // make darker or brighter
    //rr += bright;
    //gg += bright;
    //bb += bright;
    // constrain RGB to make sure they are within 0-255 color range

    rr = MathFP.clamp(rr + bright, 0, 255);
    gg = MathFP.clamp(gg + bright, 0, 255);
    bb = MathFP.clamp(bb + bright, 0, 255);

    // reassemble colors back into pixel
    return color(rr, gg, bb, 255);
  }

  void draw(int currentTime, int[] renderBuffer) {
    int m = currentTime >> 4;
    int ci;
    int is = ci = 0;
    int yi = 1;
    int cii = rw;
    int count = 0;

    for (int y = 0; y < rh; y++) {
      for (int x = 0; x < rw; x++) {
        renderBuffer[count++] = 0;
      }

      ci += cii;
      int i = (y * rw) + (rw >> 2) + 32;
      int a = framec3 + (y >> 2) + costab[framec3 + y * costab[framec2 & 0xff] >> 9 & 0xff] & 0xff;

      for (int n = 0; n < 4; n++) {
        int a2 = a + 64 & 0xff;
        int x1 = sintab[a] >> 1;  //increasing number makes twister skinnier
        int x2 = costab[a] >> 1;
        int l = x2 - x1;
        if (l > 0) {
          x1 += i;
          int u = 0;
          int ui = 0x4000 / l; // texture width / L
          for (int x = 0; x < l; x++) {

            if (n == 1 || n == 3) {
              renderBuffer[x1 + x] = adjustBright(textureImg[((x + u >> 7) + y * 128) & 0x3FFF], 2 * l - 127);
            } 
            else {
              renderBuffer[x1 + x] = adjustBright(textureImgB[((x + u >> 7) + y * 128) & 0x3FFF], 2 * l - 127);
            }

            u += ui;
          }
        }
        a = a2;
      }
    }

    framec1 += 1;
    framec2 += 1; // lateral movement speed
    framec3 += 1; // higher number  = faster spin
  }
}

