/*

Name      :  3D Model Loader & Renderer
Notes     :  makes three dee cubes possible

nifty 3d model hander.
optimized a bit.  made rotation smoother

references:
http://www.oracle.com/technetwork/articles/java/blurayhelloworld-364958.html
http://www.pouet.scene.org/nfo.php?which=56900
http://directtovideo.wordpress.com/2011/05/03/numb-res/
 */
package demoplatform;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.IOException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public final class Threedee {

    public static int max(int i, int j) {
        return i <= j ? j : i;
    }

    public static int sqrt(int i) {
        if (i == 0) {
            return 0;
        }
        int l = 0;
        int j;

        j = (i >= 1024) ? 1024 : 1;

        do {
            int k = (i << 10) / j;
            j = j + k >> 1;
            l = k - j;
            l = l <= 0 ? -l : l;
        } while (l > 1);
        return j;
    }

    public static void initIdentity() {
        m_00 = m_11 = m_22 = 1024;
        m_01 = m_02 = m_10 = m_12 = m_20 = m_21 = 0;
        m_30 = m_31 = m_32 = 1024;
        m_03 = m_13 = m_23 = 0;
        m_33 = 1024;
    }

    public static void normVVV() {
        ai4_0 = vc_0 - va_0;
        ai4_1 = vc_1 - va_1;
        ai4_2 = vc_2 - va_2;
        ai5_0 = vb_0 - va_0;
        ai5_1 = vb_1 - va_1;
        ai5_2 = vb_2 - va_2;

        vn_0 = (ai4_1 * ai5_2 + 512 >> globalScale) - (ai4_2 * ai5_1 + 512 >> globalScale);
        vn_1 = (ai4_2 * ai5_0 + 512 >> globalScale) - (ai4_0 * ai5_2 + 512 >> globalScale);
        vn_2 = (ai4_0 * ai5_1 + 512 >> globalScale) - (ai4_1 * ai5_0 + 512 >> globalScale);
    }

    public static void normV() {

        //ai1[0] = ai[0];
        //ai1[1] = ai[1];
        //ai1[2] = ai[2];
        int i = sqrt((vn_0 * vn_0 + 512 >> globalScale) + (vn_1 * vn_1 + 512 >> globalScale) + (vn_2 * vn_2 + 512 >> globalScale));
        if (i != 0) {
            i = 0x100000 / i;
        }
        vn_0 = vn_0 * i + 512 >> globalScale;
        vn_1 = vn_1 * i + 512 >> globalScale;
        vn_2 = vn_2 * i + 512 >> globalScale;
    }

    public static int dotVV(int light0, int light1, int light2) {
        return (light0 * vn_0 + 512 >> globalScale) + (light1 * vn_1 + 512 >> globalScale) + (light2 * vn_2 + 512 >> globalScale);
    }

    //tmpint4x4b , tmpint4x4a
    public static void multMM() {
        tmpint4x4b_00 = m_00;
        tmpint4x4b_01 = m_01;
        tmpint4x4b_02 = m_02;
        tmpint4x4b_10 = m_10;
        tmpint4x4b_11 = m_11;
        tmpint4x4b_12 = m_12;
        tmpint4x4b_20 = m_20;
        tmpint4x4b_21 = m_21;
        tmpint4x4b_22 = m_22;

        m_00 = (tmpint4x4b_00 * tmpint4x4a_00 + 512 >> globalScale) + (tmpint4x4b_01 * tmpint4x4a_10 + 512 >> globalScale) + (tmpint4x4b_02 * tmpint4x4a_20 + 512 >> globalScale);
        m_01 = (tmpint4x4b_00 * tmpint4x4a_01 + 512 >> globalScale) + (tmpint4x4b_01 * tmpint4x4a_11 + 512 >> globalScale) + (tmpint4x4b_02 * tmpint4x4a_21 + 512 >> globalScale);
        m_02 = (tmpint4x4b_00 * tmpint4x4a_02 + 512 >> globalScale) + (tmpint4x4b_01 * tmpint4x4a_12 + 512 >> globalScale) + (tmpint4x4b_02 * tmpint4x4a_22 + 512 >> globalScale);
        m_10 = (tmpint4x4b_10 * tmpint4x4a_00 + 512 >> globalScale) + (tmpint4x4b_11 * tmpint4x4a_10 + 512 >> globalScale) + (tmpint4x4b_12 * tmpint4x4a_20 + 512 >> globalScale);
        m_11 = (tmpint4x4b_10 * tmpint4x4a_01 + 512 >> globalScale) + (tmpint4x4b_11 * tmpint4x4a_11 + 512 >> globalScale) + (tmpint4x4b_12 * tmpint4x4a_21 + 512 >> globalScale);
        m_12 = (tmpint4x4b_10 * tmpint4x4a_02 + 512 >> globalScale) + (tmpint4x4b_11 * tmpint4x4a_12 + 512 >> globalScale) + (tmpint4x4b_12 * tmpint4x4a_22 + 512 >> globalScale);
        m_20 = (tmpint4x4b_20 * tmpint4x4a_00 + 512 >> globalScale) + (tmpint4x4b_21 * tmpint4x4a_10 + 512 >> globalScale) + (tmpint4x4b_22 * tmpint4x4a_20 + 512 >> globalScale);
        m_21 = (tmpint4x4b_20 * tmpint4x4a_01 + 512 >> globalScale) + (tmpint4x4b_21 * tmpint4x4a_11 + 512 >> globalScale) + (tmpint4x4b_22 * tmpint4x4a_21 + 512 >> globalScale);
        m_22 = (tmpint4x4b_20 * tmpint4x4a_02 + 512 >> globalScale) + (tmpint4x4b_21 * tmpint4x4a_12 + 512 >> globalScale) + (tmpint4x4b_22 * tmpint4x4a_22 + 512 >> globalScale);
    }

    public static void multMV(byte ai1[], int ai2[]) {

        ai2[0] = (ai1[0] * m_00 + 512 >> 2) + (ai1[1] * m_01 + 512 >> 2) + (ai1[2] * m_02 + 512 >> 2);
        ai2[1] = (ai1[0] * m_10 + 512 >> 2) + (ai1[1] * m_11 + 512 >> 2) + (ai1[2] * m_12 + 512 >> 2);
        ai2[2] = (ai1[0] * m_20 + 512 >> 2) + (ai1[1] * m_21 + 512 >> 2) + (ai1[2] * m_22 + 512 >> 2);
    }

    public static void multMV_va(byte ai1[], int ai2[]) {
        ai2[0] = (ai1[0] * m_00 + 512 >> 2) + (ai1[1] * m_01 + 512 >> 2) + (ai1[2] * m_02 + 512 >> 2);
        ai2[1] = (ai1[0] * m_10 + 512 >> 2) + (ai1[1] * m_11 + 512 >> 2) + (ai1[2] * m_12 + 512 >> 2);
        ai2[2] = (ai1[0] * m_20 + 512 >> 2) + (ai1[1] * m_21 + 512 >> 2) + (ai1[2] * m_22 + 512 >> 2);
    }

    public static void rotate(int i, int j, int k) {
        if (k != 0) {
            //for(; k < 0; k += 6434);
            sc_0 = ((k % 6434) << 6 + 512) / 6434;
            sc_1 = sc_0 + 16;
            sc_0 = sine[sc_0 % 64];
            sc_1 = sine[sc_1 % 64];
            tmpint4x4a_00 = sc_1;
            tmpint4x4a_01 = -sc_0;
            tmpint4x4a_02 = 0;
            tmpint4x4a_10 = sc_0;
            tmpint4x4a_11 = sc_1;
            tmpint4x4a_12 = 0;
            tmpint4x4a_20 = 0;
            tmpint4x4a_21 = 0;
            tmpint4x4a_22 = 1024;
            multMM();
        }
        if (j != 0) {
            // for(; j < 0; j += 6434);
            sc_0 = ((j % 6434) << 6 + 512) / 6434;
            sc_1 = sc_0 + 16;
            sc_0 = sine[sc_0 % 64];
            sc_1 = sine[sc_1 % 64];
            tmpint4x4a_00 = sc_1;
            tmpint4x4a_01 = 0;
            tmpint4x4a_02 = -sc_0;
            tmpint4x4a_10 = 0;
            tmpint4x4a_11 = 1024;
            tmpint4x4a_12 = 0;
            tmpint4x4a_20 = sc_0;
            tmpint4x4a_21 = 0;
            tmpint4x4a_22 = sc_1;
            multMM();
        }
        if (i != 0) {
            //for(; i < 0; i += 6434);
            sc_0 = ((i % 6434) << 6 + 512) / 6434;
            sc_1 = sc_0 + 16;
            sc_0 = sine[sc_0 % 64];
            sc_1 = sine[sc_1 % 64];
            tmpint4x4a_00 = 1024;
            tmpint4x4a_01 = 0;
            tmpint4x4a_02 = 0;
            tmpint4x4a_10 = 0;
            tmpint4x4a_11 = sc_1;
            tmpint4x4a_12 = -sc_0;
            tmpint4x4a_20 = 0;
            tmpint4x4a_21 = sc_0;
            tmpint4x4a_22 = sc_1;
            multMM();
        }
    }

    public void paintFlush(Graphics g) {
        //if(colorbuffer != null)
        //    g.drawRGB(colorbuffer, 0, w_, 0, 0, w_, h_, false);
    }

    public void coord(int i, int ai[]) {
        multMV(obj_vv[i], ai);
        vn_0 = vn_0 + 512 >> globalScale;
        vn_1 = vn_1 + 512 >> globalScale;
        vn_2 = vn_2 + 512 >> globalScale;
        vn_0 = (vn_0 << 2) + screen_0;
        vn_1 = -(vn_1 << 2) + screen_1;
        vn_2 = (vn_2 << 2) + screen_2;
    }

    public void paintLine(Graphics g) {
        int i = 224;
        for (int j = 0; j < obj_nf; j++) {
            multMV(obj_vv[obj_vf[j][0]], va);
            multMV(obj_vv[obj_vf[j][1]], vb);
            multMV(obj_vv[obj_vf[j][2]], vc);
            va_0 = va_0 + 512 >> superScale;
            va_1 = va_1 + 512 >> superScale;
            va_2 = va_2 + 512 >> superScale;
            va_0 = (va_0) + screen_0;
            va_1 = -(va_1) + screen_1;
            va_2 = (va_2) + screen_2;
            vb_0 = vb_0 + 512 >> superScale;
            vb_1 = vb_1 + 512 >> superScale;
            vb_2 = vb_2 + 512 >> superScale;
            vb_0 = (vb_0) + screen_0;
            vb_1 = -(vb_1) + screen_1;
            vb_2 = (vb_2) + screen_2;
            vc_0 = vc_0 + 512 >> superScale;
            vc_1 = vc_1 + 512 >> superScale;
            vc_2 = vc_2 + 512 >> superScale;
            vc_0 = (vc_0) + screen_0;
            vc_1 = -(vc_1) + screen_1;
            vc_2 = (vc_2) + screen_2;
            if (obj_vc != null) {
                i = obj_vc[j];
            }
            //g.setColor(i);
            g.setColor(new Color(i, i, i));

            g.drawLine(va_0, va_1, vb_0, vb_1);
            g.drawLine(va_0, va_1, vc_0, vc_1);
            g.drawLine(vc_0, vc_1, vb_0, vb_1);
        }

    }

    public void paintFlat(Graphics g) {
        char c = '\340';
        for (int i = 0; i < obj_nf; i++) {
            multMV(obj_vv[obj_vf[i][0]], va);
            multMV(obj_vv[obj_vf[i][1]], vb);
            multMV(obj_vv[obj_vf[i][2]], vc);
            va_0 = va_0 + 512 >> globalScale;
            va_1 = va_1 + 512 >> globalScale;
            va_2 = va_2 + 512 >> globalScale;
            va_0 = (va_0 << 2) + screen_0;
            va_1 = -(va_1 << 2) + screen_1;
            va_2 = (va_2 << 2) + screen_2;
            vb_0 = vb_0 + 512 >> globalScale;
            vb_1 = vb_1 + 512 >> globalScale;
            vb_2 = vb_2 + 512 >> globalScale;
            vb_0 = (vb_0 << 2) + screen_0;
            vb_1 = -(vb_1 << 2) + screen_1;
            vb_2 = (vb_2 << 2) + screen_2;
            vc_0 = vc_0 + 512 >> globalScale;
            vc_1 = vc_1 + 512 >> globalScale;
            vc_2 = vc_2 + 512 >> globalScale;
            vc_0 = (vc_0 << 2) + screen_0;
            vc_1 = -(vc_1 << 2) + screen_1;
            vc_2 = (vc_2 << 2) + screen_2;
            //g.setColor(c);
            g.setColor(new Color(c, c, c));
            //g.fillTriangle(va_0, va_1, vb_0, vb_1, vc_0, vc_1);


            int[] xPoints = {va_0, vb_0, vc_0};
            int[] yPoints = {va_1, vb_1, vc_1};

            g.fillPolygon(xPoints, yPoints, 3);
            //g.drawPolygon(xPoints, yPoints, 3);

        }
    }

    public void paintFront(Graphics g) {
        for (int i = 0; i < obj_nf; i++) {
            multMV(obj_vv[obj_vf[i][0]], va);
            multMV(obj_vv[obj_vf[i][1]], vb);
            multMV(obj_vv[obj_vf[i][2]], vc);
            normVVV();
            if (vn_2 <= 0) {
                va_0 = va_0 + 512 >> globalScale;
                va_1 = va_1 + 512 >> globalScale;
                va_2 = va_2 + 512 >> globalScale;
                va_0 = (va_0 << 2) + screen_0;
                va_1 = -(va_1 << 2) + screen_1;
                va_2 = (va_2 << 2) + screen_2;
                vb_0 = vb_0 + 512 >> globalScale;
                vb_1 = vb_1 + 512 >> globalScale;
                vb_2 = vb_2 + 512 >> globalScale;
                vb_0 = (vb_0 << 2) + screen_0;
                vb_1 = -(vb_1 << 2) + screen_1;
                vb_2 = (vb_2 << 2) + screen_2;
                vc_0 = vc_0 + 512 >> globalScale;
                vc_1 = vc_1 + 512 >> globalScale;
                vc_2 = vc_2 + 512 >> globalScale;
                vc_0 = (vc_0 << 2) + screen_0;
                vc_1 = -(vc_1 << 2) + screen_1;
                vc_2 = (vc_2 << 2) + screen_2;
                g.drawLine(va_0, va_1, vb_0, vb_1);
                g.drawLine(va_0, va_1, vc_0, vc_1);
                g.drawLine(vc_0, vc_1, vb_0, vb_1);
            }
        }

    }

    public void paintSort(Graphics g) {
        /*
        if(obj_trans == null || obj_center == null)
        {
        return;
        }
         */

        for (int i = 0; i < obj_nv; i++) {
            multMV(obj_vv[i], obj_trans[i]);
        }

        for (int j = 0; j < obj_nf; j++) {
            va_0 = obj_trans[obj_vf[j][0]][0];
            va_1 = obj_trans[obj_vf[j][0]][1];
            va_2 = obj_trans[obj_vf[j][0]][2];
            vb_0 = obj_trans[obj_vf[j][1]][0];
            vb_1 = obj_trans[obj_vf[j][1]][1];
            vb_2 = obj_trans[obj_vf[j][1]][2];
            vc_0 = obj_trans[obj_vf[j][2]][0];
            vc_1 = obj_trans[obj_vf[j][2]][1];
            vc_2 = obj_trans[obj_vf[j][2]][2];
            obj_center[j][2] = va_2 + vb_2 + vc_2;
        }

        quickSort(obj_center, 0, obj_nf - 1);


        for (int k = 0; k < obj_nf; k++) {
            va_0 = obj_trans[obj_vf[k][0]][0];
            va_1 = obj_trans[obj_vf[k][0]][1];
            va_2 = obj_trans[obj_vf[k][0]][2];
            vb_0 = obj_trans[obj_vf[k][1]][0];
            vb_1 = obj_trans[obj_vf[k][1]][1];
            vb_2 = obj_trans[obj_vf[k][1]][2];
            vc_0 = obj_trans[obj_vf[k][2]][0];
            vc_1 = obj_trans[obj_vf[k][2]][1];
            vc_2 = obj_trans[obj_vf[k][2]][2];

            normVVV();
            if (vn_2 > 0) {
                continue;
            }

            // bigger superscale value makes smaller object
            // left shift makes darker
            vn_0 = (vn_0 + 512 >> superScale) << 2;
            vn_1 = (vn_1 + 512 >> superScale) << 2;
            vn_2 = (vn_2 + 512 >> superScale) << 2;

            normV();

            int l = (dotVV(light_0, light_1, light_2) << 6) >> 10;
            //int l = dotVV(light_0,light_1,light_2);
            //l = (l * 64) / 1024;
            if (l >= 64) {
                l = 63;
            }
            if (l < 0) {
                l = 0;
            }

            va_0 = va_0 + 512 >> superScale;
            va_1 = va_1 + 512 >> superScale;
            va_2 = va_2 + 512 >> superScale;

            va_0 = va_0 + screen_0;
            va_1 = -va_1 + screen_1;
            va_2 = va_2 + screen_2;

            vb_0 = vb_0 + 512 >> superScale;
            vb_1 = vb_1 + 512 >> superScale;
            vb_2 = vb_2 + 512 >> superScale;
            vb_0 = vb_0 + screen_0;
            vb_1 = -vb_1 + screen_1;
            vb_2 = vb_2 + screen_2;

            vc_0 = vc_0 + 512 >> superScale;
            vc_1 = vc_1 + 512 >> superScale;
            vc_2 = vc_2 + 512 >> superScale;
            vc_0 = vc_0 + screen_0;
            vc_1 = -vc_1 + screen_1;
            vc_2 = vc_2 + screen_2;

            /*
            int i1 = colormap[l];
            if(obj_vc != null)
            i1 &= obj_vc[k];
            g.setColor(i1);
             */

            //g.setColor((obj_vc != null) ? colormap[l] & obj_vc[k] : colormap[l]);
            //g.fillTriangle(va_0 , va_1, vb_0, vb_1, vc_0, vc_1);

            //g.setColor(colormapObj[l]);

            g.setColor(new Color(l,l,l));

            //g.fillTriangle(va_0, va_1, vb_0, vb_1, vc_0, vc_1);


            /*
            // method 1
            int[] xPoints = {va_0, vb_0, vc_0};
            int[] yPoints = {va_1, vb_1, vc_1};
            //g.drawPolygon(xPoints, yPoints, 3); // this draws lines
            g.fillPolygon(xPoints, yPoints, 3);
*/

            // method 2
            Polygon a = new Polygon();
            a.addPoint(va_0+150, va_1);
            a.addPoint(vb_0+150, vb_1);
            a.addPoint(vc_0+150, vc_1);
            g.fillPolygon(a);


            // method 3
            //fillTriangle(va_0-150,va_1,vb_0-150,vb_1,vc_0-150,vc_1,g);



        }
    }

    protected void fillTriangle(int ax, int ay, int bx, int by, int cx, int cy, Graphics g) {
        // http://www.geocities.com/wronski12/3d_tutor/tri_fillers.html

        // Sort the points so that ay <= by <= cy
        int temp;
        if (ay > by) {
            temp = ax;
            ax = bx;
            bx = temp;
            temp = ay;
            ay = by;
            by = temp;
        }
        if (by > cy) {
            temp = bx;
            bx = cx;
            cx = temp;
            temp = by;
            by = cy;
            cy = temp;
        }
        if (ay > by) {
            temp = ax;
            ax = bx;
            bx = temp;
            temp = ay;
            ay = by;
            by = temp;
        }

        // Calc the deltas for each edge.
        int ab_num;
        int ab_den;
        if (by - ay > 0) {
            ab_num = (bx - ax);
            ab_den = (by - ay);
        } else {
            ab_num = (bx - ax);
            ab_den = 1;
        }

        int ac_num;
        int ac_den;
        if (cy - ay > 0) {
            ac_num = (cx - ax);
            ac_den = (cy - ay);
        } else {
            ac_num = 0;
            ac_den = 1;
        }

        int bc_num;
        int bc_den;
        if (cy - by > 0) {
            bc_num = (cx - bx);
            bc_den = (cy - by);
        } else {
            bc_num = 0;
            bc_den = 1;
        }

        // The start and end of each line.
        int sx;
        int ex;

        // The heights of the two components of the triangle.
        int h1 = by - ay;
        int h2 = cy - by;

        // Some calculations extracted from the loops.
        int ab_num_x2 = ab_num * 2;
        int ab_den_x2 = ab_den * 2;

        int ac_num_x2 = ac_num * 2;
        int ac_den_x2 = ac_den * 2;

        int bc_num_x2 = bc_num * 2;
        int bc_den_x2 = bc_den * 2;

        // If a is to the left of b...
        if (ax < bx) {
            // For each row of the top component...
            for (int y = 0; y < h1; y++) {
                sx = ax + (ac_num_x2 * y + ac_den) / ac_den_x2;
                ex = ax + (ab_num_x2 * y + ab_den) / ab_den_x2;
                drawHorizontalLine(sx, ex, ay + y, g);
            }
            // For each row of the bottom component...
            for (int y = 0; y < h2; y++) {
                int y2 = h1 + y;
                sx = ax + (ac_num_x2 * y2 + ac_den) / ac_den_x2;
                ex = bx + (bc_num_x2 * y + bc_den) / bc_den_x2;
                drawHorizontalLine(sx, ex, by + y, g);
            }
        } else {
            // For each row of the bottom component...
            for (int y = 0; y < h1; y++) {
                sx = ax + (ab_num_x2 * y + ab_den) / ab_den_x2;
                ex = ax + (ac_num_x2 * y + ac_den) / ac_den_x2;
                drawHorizontalLine(sx, ex, ay + y, g);
            }
            // For each row of the bottom component...
            for (int y = 0; y < h2; y++) {
                int y2 = h1 + y;
                sx = bx + (bc_num_x2 * y + bc_den) / bc_den_x2;
                ex = ax + (ac_num_x2 * y2 + ac_den) / ac_den_x2;
                drawHorizontalLine(sx, ex, by + y, g);
            }
        }
    }

    protected void drawHorizontalLine(int x1, int x2, int y, Graphics g) {
        // For odd numbered lines...
        if ((y & 1) == 1) {
            // Paint magenta.
            //g.setColor(255,0,255);
        } else {
            // Paint yellow.
            //  g.setColor(255,255,0);
        }
        // Draw the line.
        g.drawLine(x1, y, x2, y);
    }

    private void swapArray(int ai[][], int i, int j) {
        int ai1[] = ai[i];
        ai[i] = ai[j];
        ai[j] = ai1;
        int k = obj_vf[i][0];
        obj_vf[i][0] = obj_vf[j][0];
        obj_vf[j][0] = k;
        k = obj_vf[i][1];
        obj_vf[i][1] = obj_vf[j][1];
        obj_vf[j][1] = k;
        k = obj_vf[i][2];
        obj_vf[i][2] = obj_vf[j][2];
        obj_vf[j][2] = k;
        if (obj_vc != null) {
            int l = obj_vc[i];
            obj_vc[i] = obj_vc[j];
            obj_vc[j] = l;
        }
    }

    protected void quickSort(int ai[][], int i, int j) {


        int k = i;
        int l = j;
        if (j > i) {
            int ai1[] = ai[i + j >> 1];

            do {
                if (k > l) {
                    break;
                }
                for (; k < j && ai[k][2] < ai1[2]; k++);
                for (; l > i && ai1[2] < ai[l][2]; l--);
                if (k <= l) {
                    swapArray(ai, k, l);
                    k++;
                    l--;
                }
            } while (true);
            if (i < l) {
                quickSort(ai, i, l);
            }
            if (k < j) {
                quickSort(ai, k, j);
            }
        }
    }

    public Threedee() {
        w_ = 160;
        h_ = w_;
        hw_ = h_ * w_;
        rx_ = -1;
        ry_ = -1;
        rz_ = 1;
        updated = 0;
        mode = 12;




        obj_nv = 8;
        obj_nf = 12;
        obj_vv = mesh_cube_vv;
        obj_vf = mesh_cube_vf;
        obj_vc = null;

        obj_trans = (int[][]) null;
        obj_norm = (int[][]) null;
        obj_center = (int[][]) null;
        //rotation_ = 100;
        init();




    }

    private byte[][] loadModel(String file, int length) {
        byte[] face;
        byte[] vertex = new byte[length];

        try {
            vertex = loadBytes(file);
        } catch (IOException ioe) {
        }

        // {{-29,-13,74},{-43,-13,69}}
        byte[][] C; // array we are building
        C = new byte[length][3];
        int V = 0;
        for (int y = 0; y < length * 3;) { // loop through entire string "000I@H1@H1>9"
            for (int x = 0; x < 3;) { // loop either 3 or 4 times
                C[V][x++] = vertex[y]; // append either points to new array or index position
                y++;
            }
            V++;
        }
        return C;
    }

    private int[][] loadFace(String file, int length) {
        byte[] face;
        byte[] vertex = new byte[length];

        try {
            vertex = loadBytes(file);
        } catch (IOException ioe) {
        }

        // {{-29,-13,74},{-43,-13,69}}
        int[][] C; // array we are building
        C = new int[length][3];
        int V = 0;
        for (int y = 0; y < length * 3;) { // loop through entire string "000I@H1@H1>9"
            for (int x = 0; x < 3;) { // loop either 3 or 4 times
                C[V][x++] = vertex[y] + 127; // append either points to new array or index position
                y++;
            }
            V++;
        }
        return C;
    }

    private int[] loadColor(String file, int length) {
        byte[] vertex = new byte[length];

        try {
            vertex = loadBytes(file);
        } catch (IOException ioe) {
        }

        int[] colorByte = new int[length];
        int colorIndex = 0;
        int r;
        int g;
        int b;

        for (int y = 0; y < length * 3;) { // loop through entire string "000I@H1@H1>9"
            //a = vertex[y++];
            r = vertex[y++] + 127;
            g = vertex[y++] + 127;
            b = vertex[y++] + 127;
            colorByte[colorIndex++] = (r << 16) | (g << 8) | b;
        }





        return colorByte;
    }

    private byte[] loadBytes(String name) throws IOException {
        InputStream in = getClass().getResourceAsStream(name);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int c;
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        byte[] raw = out.toByteArray();
        out.close();
        return raw;
    }

    public Threedee(int i, int j) {
        w_ = 160;
        h_ = w_;
        hw_ = h_ * w_;
        rx_ = -1;
        ry_ = -1;
        rz_ = 0;
        updated = 0;
        mode = 12;

        obj_nv = 8;
        obj_nf = 12;
        obj_vv = mesh_cube_vv;
        obj_vf = mesh_cube_vf;
        obj_vc = null;



        obj_trans = (int[][]) null;
        obj_norm = (int[][]) null;
        obj_center = (int[][]) null;
        rotation_ = 64;
        init(i, j);
    }


    // first load
    public void init(int i, int j) {
        w_ = i;
        h_ = j;
        init();


        // 1 =  sphere
        // 0 = cube
        //toggleShape(0);

        //"demo", "dots", "wire", "flat", "front", "face", "light6", "dynlight7", "test/mixed", "test/full",
        // "pixel", "zsort 11", "zsort+light 12"

        toggleMode(12);
        //tick++;
    }

    public void init() {
        screen_0 = w_ / 2;
        screen_1 = h_ / 2;
        screen_2 = h_;
        colormap = new int[64];
        colormapObj = new Color[64];


        byte byte0 = 3;
        int i = 0;
        for (int j = 0; j < 64; j++) {
            i += byte0;

            int test = i + (i << 8) + (i << 16);
            colormap[j] = i + (i << 8) + (i << 16);
            colormapObj[j] = new Color( i,i,i);
            //new Color(l, l, l)
        }

        reset();
        rz_ = ry_ = 1;
    }

    public void reset() {
        initIdentity();
        rx_ = ry_ = rz_ = 0;
    }

    public void toggleShape(int i) {
        shape = i;
        switch (i) {
            case 1: // cube
                obj_nv = 8;
                obj_nf = 12;
                obj_vv = mesh_cube_vv;
                obj_vf = mesh_cube_vf;
                obj_vc = null;
                obj_trans = (int[][]) null;
                obj_center = (int[][]) null;
                break;

            case 2: // star
                obj_nv = 42;
                obj_nf = 80;
                obj_vv = loadModel("/models/star/star.vert", obj_nv); // number of faces
                obj_vf = loadFace("/models/star/star.face", obj_nf); // number of faces
                obj_vc = loadColor("/models/star/star.pal", obj_nf); //color
                //obj_vc = null;
                obj_trans = (int[][]) null;
                obj_center = (int[][]) null;
                break;

            case 3: // at party logo
                obj_nv = 156;
                obj_nf = 308;
                obj_vv = loadModel("/models/logo/logo.vert", obj_nv); // number of faces
                obj_vf = loadFace("/models/logo/logo.face", obj_nf); // number of faces

                obj_vc = null;
                obj_trans = (int[][]) null;
                obj_center = (int[][]) null;
                break;


            case 4: // twisted knot
                obj_nv = 180;
                obj_nf = 360;
                obj_vv = loadModel("/models/torus_knot/torus_knot.vert", obj_nv); // number of faces
                obj_vf = loadFace("/models/torus_knot/torus_knot.face", obj_nf); // number of faces
                obj_vc = loadColor("/models/torus_knot/torus_knot.pal", obj_nf); //color
                //obj_vc = null;
                obj_trans = (int[][]) null;
                obj_center = (int[][]) null;
                break;


            case 5: // teapot
                obj_nv = 122; //138;
                obj_nf = 208; //256;
                obj_vv = loadModel("/models/teapot/teapot.vert", obj_nv); // number of faces
                obj_vf = loadFace("/models/teapot/teapot.face", obj_nf); // number of faces
                obj_vc = null;
                obj_trans = (int[][]) null;
                obj_center = (int[][]) null;
                break;


            case 6: // cup
                obj_nv = 57; //138;
                obj_nf = 110; //256;
                obj_vv = loadModel("/models/cup/cup.vert", obj_nv); // number of faces
                obj_vf = loadFace("/models/cup/cup.face", obj_nf); // number of faces
                obj_vc = loadColor("/models/cup/cup.pal", obj_nf); //color
                obj_trans = (int[][]) null;
                obj_center = (int[][]) null;
                break;


            case 7: // torus
                obj_nv = 91; //138;
                obj_nf = 182; //256;
                obj_vv = loadModel("/models/torus/torus.vert", obj_nv); // number of faces
                obj_vf = loadFace("/models/torus/torus.face", obj_nf); // number of faces
                obj_vc = loadColor("/models/torus/torus.pal", obj_nf); //color
                obj_trans = (int[][]) null;
                obj_center = (int[][]) null;
                break;


            case 8: // cheese
                obj_nv = 68; //138;
                obj_nf = 132; //256;
                obj_vv = loadModel("/models/cheese/cheese.vert", obj_nv); // number of faces
                obj_vf = loadFace("/models/cheese/cheese.face", obj_nf); // number of faces
                obj_vc = loadColor("/models/cheese/cheese.pal", obj_nf); //color
                obj_trans = (int[][]) null;
                obj_center = (int[][]) null;
                break;



            default:
                obj_nv = 8;
                obj_nf = 12;
                obj_vv = mesh_cube_vv;
                obj_vf = mesh_cube_vf;
                obj_vc = null;
                obj_trans = (int[][]) null;
                obj_center = (int[][]) null;
                shape = 0;
                break;
        }
        recalc();
    }

    public void toggleShape() {
        toggleShape(1 + shape);
    }

    public void toggleMode() {
        toggleMode(mode + 1);
    }

    public void recalc() {
        System.gc();
        obj_trans = new int[obj_nv][3];
        obj_center = new int[obj_nf][3];
    }

    public void toggleMode(int i) {
        light_0 = 0;
        light_1 = 0;
        light_2 = -1024;
        mode = i;
        /*
        if(mode >= vmode.length)
        {
        toggleShape();
        mode = 12;
        }
         */
        recalc();
    }

    public void draw(Graphics g) {
        rx_ = rx_ % 64;
        ry_ = ry_ % 64;
        rz_ = rz_ % 64;
        //rotate(rx_ * rotation_, ry_ * rotation_, rz_ * rotation_);
        rotate(rx_ << 7, ry_ << 7, rz_ << 7);
        updated++;
        paintSort(g);

        //paintDynLight(g);
    }

    public void spin() {
        rotate(rx_, rotation_ >> 2, rotation_);
        //updated++;
    }

    // vertex must be between -11585 and +11585
    static byte cube_n = -80;
    static byte cube_p = 80;
    public static final byte mesh_cube_vv[][] = {{cube_n, cube_n, cube_n}, {cube_p, cube_n, cube_n}, {cube_n, cube_p, cube_n}, {cube_p, cube_p, cube_n}, {cube_n, cube_n, cube_p}, {cube_p, cube_n, cube_p}, {cube_n, cube_p, cube_p}, {cube_p, cube_p, cube_p}};
    public static final int mesh_cube_vf[][] = {{0, 2, 3}, {3, 1, 0}, {4, 5, 7}, {7, 6, 4}, {0, 1, 5}, {5, 4, 0}, {1, 3, 7}, {7, 5, 1}, {3, 2, 6}, {6, 7, 3}, {2, 0, 4}, {4, 6, 2}};
    static int init = 0;
    public int w_;
    public int h_;
    public int hw_;
    int screen_0 = 0;
    int screen_1 = 0;
    int screen_2 = 0;
    static final int scale = 2;
    static public int globalScale = 10;
    public int superScale = 7;
    public int rx_;
    public int ry_;
    public int rz_;
    public int updated;
    public int mode;
    static int shape = 0;
    public static final int PI = 3217;
    public static final int sine[] = {
        0, 100, 200, 297, 392, 483, 569, 650, 724, 792,
        851, 903, 946, 980, 1004, 1019, 1024, 1019, 1004, 980,
        946, 903, 851, 792, 724, 650, 569, 483, 392, 297,
        200, 100, 0, -100, -200, -297, -392, -483, -569, -650,
        -724, -792, -851, -903, -946, -980, -1004, -1019, -1024, -1019,
        -1004, -980, -946, -903, -851, -792, -724, -650, -569, -483,
        -392, -297, -200, -100
    };
    static int tmpint4x4a_00;
    static int tmpint4x4a_01;
    static int tmpint4x4a_02;
    static int tmpint4x4a_03;
    static int tmpint4x4a_10;
    static int tmpint4x4a_11;
    static int tmpint4x4a_12;
    static int tmpint4x4a_13;
    static int tmpint4x4a_20;
    static int tmpint4x4a_21;
    static int tmpint4x4a_22;
    static int tmpint4x4a_23;
    static int tmpint4x4a_30; // not needed?
    static int tmpint4x4a_31;
    static int tmpint4x4a_32;
    static int tmpint4x4a_33;
    static int tmpint4x4b_00;
    static int tmpint4x4b_01;
    static int tmpint4x4b_02;
    static int tmpint4x4b_03;
    static int tmpint4x4b_10;
    static int tmpint4x4b_11;
    static int tmpint4x4b_12;
    static int tmpint4x4b_13;
    static int tmpint4x4b_20;
    static int tmpint4x4b_21;
    static int tmpint4x4b_22;
    static int tmpint4x4b_23;
    static int colorbuffer[] = null;
    static int bound = 16382;
    static int colormap[] = null;
    Color colormapObj[]=null;
    static final int colormapsize = 64;

    static int m_00;
    static int m_01;
    static int m_02;
    static int m_03;
    static int m_10;
    static int m_11;
    static int m_12;
    static int m_13;
    static int m_20;
    static int m_21;
    static int m_22;
    static int m_23;
    static int m_30;
    static int m_31;
    static int m_32;
    static int m_33;
    static int sc_0;
    static int sc_1;
    static int va[] = {
        0, 0, 0
    };
    static int vb[] = {
        0, 0, 0
    };
    static int vc[] = {
        0, 0, 0
    };
    static int vn[] = {
        0, 0, 0
    };
    static int va_0 = 0;
    static int va_1 = 0;
    static int va_2 = 0;
    static int vb_0 = 0;
    static int vb_1 = 0;
    static int vb_2 = 0;
    static int vc_0 = 0;
    static int vc_1 = 0;
    static int vc_2 = 0;
    static int vn_0 = 0;
    static int vn_1 = 0;
    static int vn_2 = 0;
    static int ai4_0 = 0;
    static int ai4_1 = 0;
    static int ai4_2 = 0;
    static int ai5_0 = 0;
    static int ai5_1 = 0;
    static int ai5_2 = 0;
    int light_0 = 0;
    int light_1 = 0;
    int light_2 = 1024;
    int obj_nv;
    int obj_nf;
    byte obj_vv[][];
    int obj_vf[][];
    int obj_vc[];
    int obj_trans[][];
    int obj_norm[][];
    int obj_center[][];
    public int rotation_;
}


