/*

 Name      :  TV Noise
 Notes     :  Random pixels.
 
 Everyone's favorite effect is back.
 Sometimes the pixels are black. Other times they are white.
 It is an accurate simulatation of no signal on analog televisions.
 
 */
package demoplatform;

import java.util.Random;

public class Snow extends Demoplatform {

  int[][] px;
  private Random generator;

  public Snow() {
    debug("Snow():: initialize");
    px = new int[rw][rh]; //one line
    generator = new Random();

    for (int y = 0; y < rh; y++) {
      px[y] = new int[rw];
      for (int counter = 0; counter < rw; counter++) {
        int noise = generator.nextInt(255);
        px[y][counter] = color(noise, noise, noise, 255);
        //(              random(255) > 128) ? color(255): color(0); // black and white
      }
    }
    debug("Snow():: end initialize");
  }

  public void draw(int[] renderBuffer) {
    for (int y = 0; y < rh; y++) {
      // put a random strip of precalculated noise  
      System.arraycopy(px[generator.nextInt(rh)], 0, renderBuffer, y*rw, rw);
    }
  }
}


