/*

 Name      :  Rotozoomer
 Notes     :  A rotating and zooming bitmap.
 
 2D rotozoomers are a combination of rotation and scaling transformations
 Could possibly be the starting point for polygon texturing routines
 utilized in 3D renderers.  One of the most famous rotozoomers is the one 
 from Second Reality / Future Crew which this is based on.
 
 */
package demoplatform;

public class Rotozoomer extends Demoplatform {

  int[] sintab;
  int[] costab;
  int[] tile_bitmap;
  Julia juliatexture;

  // constructor
  public Rotozoomer() {
    debug("Rotozoomer():: initialize");
    juliatexture = new Julia(256, 256);
    debug("Rotozoomer():: create lookup tables");
    sintab = new int[256];
    costab = new int[256];
    for (int i = 0; i < 256; i++) {
      sintab[i] = (int) (Math.sin(i / 256.0 * Math.PI * 2) * 127.0 + 127.0) << 1;
      costab[i] = (int) (Math.cos(i / 256.0 * Math.PI * 2) * 127.0 + 127.0) << 1;
    }
    debug("Rotozoomer():: end initialize");
  }

  public void draw(int currentTime, int[] renderBuffer) {
    int m = (currentTime >> 5) & 0xFF; // higher number is slower and smoother
    int sv = sintab[m];
    int cv = costab[m];
    int dy = sv;
    int dx = cv;
    int ty, tx;
    int pixelIndex = 0;

    juliatexture.draw(currentTime);

    for (int y = 0; y < rh; y++) {
      ty = dy += cv;
      tx = dx += -sv;
      for (int x = 0; x < rw; x++) {
        renderBuffer[pixelIndex++] = juliatexture.texture[(((ty += sv) >> 8) + ((tx += cv) & 0xff00)) & 0xFFFF]; // 256 texture
      }
    }
  }
}

