/*

Name      :  Rasterbars
Notes     :  fake gradient horizontal bars for your screen.

not used in demo

references:
http://www.developer.nokia.com/Community/Wiki/Draw_Gradient_in_Java_ME

 */
package demoplatform;

import java.awt.Color;
import java.awt.Graphics;

public class Rasterbar extends Demoplatform {

    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    int barpos;
    int[] sintable;
    final int numbars = 8;
    final int numpos = 128;

    // constructor
    public Rasterbar() {
        debug("Sinescroller():: initialize");

        sintable = new int[128];
        for (int i = 0; i < numpos; i++) {
            sintable[i] = (rh - 40) - (int) (Math.sin(i * 3.14159265 / numpos) * (rh - 40));
        }

        debug("Sinescroller():: end initialize");
    }

    void draw(int currentTime) {
    }

    public void paint(Graphics g) {
        int pos;

        barpos = (barpos + 1) % numpos;
        pos = barpos;

        int y = sintable[pos];
        gradientBox(g, 0xffffff, 0xff0000, 0, y, rw, 20, VERTICAL);
    }

    public static void gradientBox(Graphics g, int color1, int color2, int left, int top, int width, int height, int orientation) {
        int max = orientation == VERTICAL ? height : width;

        for (int i = 0; i < max; i++) {
            Color color = midColor(color1, color2, max * (max - 1 - i) / (max - 1), max);
            g.setColor(color);

            if (orientation == VERTICAL) {
                g.drawLine(left, top + i, left + width - 1, top + i);
            } else {
                g.drawLine(left + i, top, left + i, top + height - 1);
            }
        }
    }

    static Color midColor(int color1, int color2, int prop, int max) {
        int red =
                (((color1 >> 16) & 0xff) * prop +
                ((color2 >> 16) & 0xff) * (max - prop)) / max;

        int green =
                (((color1 >> 8) & 0xff) * prop +
                ((color2 >> 8) & 0xff) * (max - prop)) / max;

        int blue =
                (((color1 >> 0) & 0xff) * prop +
                ((color2 >> 0) & 0xff) * (max - prop)) / max;

        //int color = red << 16 | green << 8 | blue;
        //return color;

        return new Color(red, green, blue);
    }
}

