/*

 Name      :  Lens
 Notes     :  A picture is shown and it looks like a magnifying glass is beeing drawn over the picture.
 
 One of the most famous demos that has a lens effect is 2nd reality by future crew.
 The trick is to precalculate the entire effect. Just make an array that for each pixel in the
 destination picture tells which pixel to take from the source picture. This array is called the
 transformation array. The tricky part is to calculate the transformation array to make the destination
 look like a lens is beeing held over the source picture.  Based on lens formula by on Abe Racadabra
 
 */
package demoplatform;

import org.dvb.ui.DVBBufferedImage;

public class Lens extends Demoplatform {

  DVBBufferedImage imgLens;  // bubble
  int[] lensArray;
  //int[] lensArrayMod;
  //int[] lensArrayDiv;
  public int[] lensEffectBG;
  //public int[] lensEffectRestore;
  //public int[] lensImage;
  int lensD = 256;
  int lensPixels = lensD * lensD;
  int ballSize = 256;
  int rightBorder = w - (ballSize); // hit right wall
  int ballRadius = ballSize / 2;
  int ballBase = h - ballSize;
  int ball_x = 0;
  int ball_y = ballRadius;              // ball position
  int ball_xv = 2;
  int ball_yv = 0;                      // ball velocity
  public DVBBufferedImage bufferImg2 = null;
  int oldX = 0;
  int oldY = 0;

  public Lens() {
    debug("Lens():: initialize");

    run();

    debug("Lens():: end initialize");
  }

  // Lens algorithm (transformation array)
  void calculate_tfm(int lensD, int magFactor) {
    int counter = 0;

    int a, b;
    int r = lensD / 2;
    int rSq = r * r;
    int s = (rSq - magFactor * magFactor);

    int x2;
    int y2;

    int temp;
    int temp2;



    // calculate the first quadrant (90 degrees) of the lens deformation, then extrapolate the other three quadrants
    for (int y = -r; y <= 0; y++) {
      y2 = y * y;
      temp = (y + r) * lensD;
      temp2 = (-y + r) * lensD;
      for (int x = -r; x <= 0; x++) {
        x2 = x * x;

        counter++;
        if (x2 + y2 >= s) {
          a = x;
          b = y;
        } 
        else {
          float z = (float) Math.sqrt(rSq - x2 - y2);
          a = (int) Math.floor(x * magFactor / z);
          b = (int) Math.floor(y * magFactor / z);
        }
        //  mirror quadrant of lens to make a complete circle
        lensArray[temp2 - (-x + r)] = ((-b + r) * lensD - (-a + r));          // bottom left
        lensArray[(temp2 + (-x + r)) - lensD] = ((-b + r) * lensD + (-a + r)) - lensD;    // bottom right
        lensArray[temp + (x + r)] = (b + r) * lensD + (a + r);           // top left
        lensArray[(temp - (x + r)) + lensD] = (b + r) * lensD - (a + r) + lensD;     // top right
      }
    }
  }

  public void run() {
    lensArray = new int[lensPixels + 1];

    //lensArrayMod = new int[lensPixels + 1];
    //lensArrayDiv = new int[lensPixels + 1];

    //  lensImage = new int[lensPixels];
    lensEffectBG = new int[lensD * lensD];
    //lensEffectRestore = new int[lensD * lensD];

    calculate_tfm(lensD, 50);

    // create two lookup arrays based on lensArray[i] to do % lensD and >> 7 separately
    /*
        for (int i = 0; i < lensPixels; i++) {
     lensArrayMod[i] = lensArray[i] % lensD;
     lensArrayDiv[i] = lensArray[i] >> 8;
     }*/

    //imgLens = getImage("/images/lens_256.png");

    imgLens = new DVBBufferedImage(lensD, lensD);
    imgLens.setRGB(0, 0, lensD, lensD, getImageArray("/images/lens_256.png"), 0, lensD);

    //lensEffectBG = getImageArray("/images/art/java_qHD.png");

    bufferImg2 = new DVBBufferedImage(w, h);
    bufferImg2.setRGB(0, 0, w, h, getImageArray("/images/art/doubleSkull.png"), 0, w);

    //imgLens.getGraphics().drawImage(imgLens, fps, fps, fps, fps, mspf, mspf, mspf, mspf, null);
  }

  void draw(int[] renderBuffer) {
    bufferImg2.getRGB(ball_x, ball_y, lensD, lensD, lensEffectBG, 0, lensD);


    // todo - unroll this loop
    for (int i = 0; i < lensPixels; i++) {
      // lensImage[i] = lensEffectBG[(ball_x + (lensArray[i] % lensD))+(ball_y + (lensArray[i] >> 8))*w];
      //   lensImage[i] = lensEffectBG[(ball_x + lensArrayMod[i]) + (ball_y + lensArrayDiv[i]) * w];
      //bufferImg.getRGB(part, part, w, h, lensArray, fps, ballSize)
      renderBuffer[i] = lensEffectBG[lensArray[i]];
    }
  }

  public void bounce() {

    oldX = ball_x;
    oldY = ball_y;

    // bounce the ball around
    ball_x += ball_xv;
    if ((ball_x < 1) || (ball_x >= rightBorder)) {
      ball_xv = -ball_xv;
    }

    ball_y += ball_yv;
    if ((ball_yv > 0) && (ball_y > ballBase)) {
      ball_y = ballBase - (ball_y - ballBase);          // reflect in YBASE
      ball_yv = -ball_yv;                               // reverse Y velocity
    }
    ball_yv++;                                        // gravity
  }
}


