package demoplatform;

import java.awt.Color;
import java.awt.Graphics;
import org.dvb.ui.DVBBufferedImage;

public class Intro extends Demoplatform {

  // Class for animating a sequence of PNGs
  Animation animation1;
  Animation animation2;
  public int frameCount = 0;
  public int frameCount2 = w;
  public int frameCount3 = 0;
  Distort distortEffect;
  int[] renderBufferTemp[];  //performance hit
  DVBBufferedImage logoImg;

  public Intro() {
    debug("Intro():: initialize");
    logoImg = new DVBBufferedImage(rw, rh, DVBBufferedImage.TYPE_ADVANCED);

    animation1 = new Animation("/images/intro/panda/", 12);
    animation2 = new Animation("/images/intro/rob2/", 2);
    plasmaNewEffect = new PlasmaNew();
    distortEffect = new Distort();
    snowEffect = new Snow();

    renderBufferTemp = new int[8][];
    renderBufferTemp[0] = getImageArray("/images/intro/revisionTrans.png");
    renderBufferTemp[1] = getImageArray("/images/intro/bd.png");
    renderBufferTemp[2] = getImageArray("/images/intro/animals.png");
    renderBufferTemp[3] = getImageArray("/images/intro/credit_luis.png");
    renderBufferTemp[4] = getImageArray("/images/intro/credit_spotter.png");
    renderBufferTemp[5] = getImageArray("/images/intro/pandaLarge.png");
    renderBufferTemp[6] = getImageArray("/images/intro/credit_forcer.png");
    renderBufferTemp[7] = getImageArray("/images/intro/credit_battlecommand.png");

    logoImg.setRGB(0, 0, rw, rh, renderBufferTemp[0], 0, rw);

    debug("Intro():: end initialize");
  }

  void draw(int compareTime, int[] renderBuffer, DVBBufferedImage buffer, Graphics graphics) {

    // skip image with tvnoise
    switch (beatCounter) {
    case 0:
      graphics.setColor(Color.black);
      graphics.fillRect(0, 0, w, h);

      distortEffect.draw(renderBuffer, renderBufferTemp[0], 3);  //revision
      break;

    case 1:
      snowEffect.draw(renderBuffer);
      distortEffect.draw(renderBuffer, renderBuffer, 3);
      break;

    case 2:
      distortEffect.draw(renderBuffer, renderBufferTemp[1], 3);  //bluray
      break;

    case 3:
      snowEffect.draw(renderBuffer);
      distortEffect.draw(renderBuffer, renderBuffer, 3);
      break;

    case 4:
      distortEffect.draw(renderBuffer, renderBufferTemp[2], 3); //tested on animals
      break;

    case 5:
      snowEffect.draw(renderBuffer);
      distortEffect.draw(renderBuffer, renderBuffer, 3);
      break;

    case 6:
      distortEffect.draw(renderBuffer, renderBufferTemp[1], 3); //bluray
      break;

    case 7:
      distortEffect.draw(renderBuffer, reescalaArray(animation2.display(7), 267, 150, 480, 270), 0); // jarig
      break;

    case 8:
      distortEffect.draw(renderBuffer, renderBufferTemp[4], 4); //bd
      break;

    case 9:
      snowEffect.draw(renderBuffer);
      distortEffect.draw(renderBuffer, renderBuffer, 3);
      break;

    case 10:
      plasmaNewEffect.draw(compareTime, renderBuffer);
      distortEffect.draw(renderBuffer, renderBuffer, 0);
      break;

    case 11:
      distortEffect.draw(renderBuffer, reescalaArray(animation1.display(6), 71, 40, 480, 270), 0); // cat
      break;

    case 12:
      distortEffect.draw(renderBuffer, renderBufferTemp[5], 3); //spotter
      break;

    case 13:
      snowEffect.draw(renderBuffer);
      distortEffect.draw(renderBuffer, renderBuffer, 3);  //revision
      break;

    case 14:
      distortEffect.draw(renderBuffer, reescalaArray(animation1.display(6), 71, 40, 480, 270), 0); // cat
      break;

    case 15:
      snowEffect.draw(renderBuffer);
      distortEffect.draw(renderBuffer, renderBuffer, 3);  //revision
      break;

    case 16:
      distortEffect.draw(renderBuffer, renderBufferTemp[6], 3);
      break;

    case 17:
      snowEffect.draw(renderBuffer);
      distortEffect.draw(renderBuffer, renderBuffer, 3);  //revision
      break;

    case 18:
      distortEffect.draw(renderBuffer, renderBufferTemp[7], 3);
      break;

    case 19:
      snowEffect.draw(renderBuffer);
      distortEffect.draw(renderBuffer, renderBuffer, 3);  //revision
      break;

    case 20:
      distortEffect.draw(renderBuffer, renderBufferTemp[3], 3);
      break;


    case 21:
      plasmaNewEffect.draw(compareTime, renderBuffer);
      distortEffect.draw(renderBuffer, renderBuffer, 0);
      break;


    default:
      break;
    }

    if (compareTime < 35000) {
      frameCount = frameCount + 120;
      if ((frameCount < w)) {

        // horizontal white line opening
        graphics.setColor(Color.white);
        graphics.fillRect((w - frameCount) / 2, (h / 2), frameCount, 5);
      } 
      else {
        if ((frameCount - w) < h) {
          renderBuffer(renderBuffer, rw, rh, 0, (h - (frameCount - w)) / 2, w, (frameCount - w), buffer, graphics);
        } 
        else {

          if (compareTime > introSnare[snareCounter]) {
            snareCounter++;
          }
          /// xxxx
          renderBuffer(renderBuffer, rw, rh, 0, 0, w, h, buffer, graphics);



          // revision logo
          if (compareTime >= 22182) {
            graphics.drawImage(logoImg, 0, 0, w, h, null);
          }
        }
      }
    }

    if (compareTime > 35000) {

      frameCount3 = frameCount3 + 150;
      if ((frameCount3 < (h * 2))) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, w, h);
        renderBuffer(renderBuffer, rw, rh, 0, (h - (frameCount3 - w)) / 2, w, (frameCount3 - w), buffer, graphics);
      } 
      else {

        if ((frameCount2 > 0)) {

          // horizontal white line ending
          graphics.setColor(Color.black);
          graphics.fillRect(0, 0, w, h);

          graphics.setColor(Color.white);
          graphics.fillRect((w - frameCount2) / 2, (h / 2), frameCount2, 5);
          frameCount2 -= 90;
        } 
        else {
          graphics.setColor(Color.black);
          graphics.fillRect(0, 0, w, h);
          return;
        }
      }
    }

    if (compareTime > beats[beatCounter]) {
      beatCounter++;
    }
  }
}

