/*

 3D engine based on EGL / jGL ES.   
 
 EGL is a pure java 3D Graphics API which was designed for J2ME mobile devices
 and based on CLDC 1.0 only, which provided OpenGL-like interface and supports
 basic 3D pipeline and texture.
 
 http://graphics.im.ntu.edu.tw/~robin/docs/icce06.pdf
 
*/

package demoplatform;

import demoplatform.GL.MathFP;
import demoplatform.GL.GL;
import demoplatform.GL.GLU;
import demoplatform.GL.Renderer;
import java.awt.Image;
import java.io.*;

public class GLSample extends Demoplatform {

  private GameCanvas cvs;
  public static final int sleepTime = 100;
  public static boolean liveFlag = true;
  public static int CSIZEW = 280;
  public static int CSIZEH = 180;
  private long lastRepaint = 0;

  public GLSample(int w, int h, String modelPath, String texturePath) {
    //	midlet=this;
    CSIZEW = w;
    CSIZEH = h;

    cvs = new GameCanvas(w, h);
    cvs.loadModel(modelPath, texturePath);
  }

  public void tex(int[] renderBuffer, int width, int height) {
    cvs.createTextureArray(renderBuffer, width, height);
  }

  void draw(int directionX, int directionY) {
    cvs.renderModel(directionX, directionY);
  }
}

class GameCanvas implements Renderer {

  public static int CSIZE = 180;
  public static int CSIZEW = 280;
  public static int CSIZEH = 180;
  private int dx, dy;
  private GL gl;
  private GLU glu;
  private boolean GLInitFlag = false;
  private int vp[];
  private int uv[];
  private int elements[];
  private int colors[];
  private int tex[] = new int[1];
  private int xrot = 0;
  private int yrot = 0;
  private Class _class;
  String output = "";

  public GameCanvas(int w, int h) {
    dx = 0;
    dx = dx > 0 ? dx : 0;
    dy = 0;
    dy = dy > 0 ? dy : 0;
    _class = getClass();

    CSIZEW = w;
    CSIZEH = h;
  }

  public void setOutput(String output) {
    this.output = output;
  }

  public int SCALE(int x) {
    return x;
  }

  public void loadModel(String modelPath, String texturePath) {
    GLInit();
    createTexture(texturePath);
    loadMds(modelPath);
  }

  public void renderModel(int directionX, int directionY) {
    gl.glClear2();
    //gl.glClear(gl.GL_COLOR_BUFFER_BIT | gl.GL_DEPTH_BUFFER_BIT);
    gl.glLoadIdentity();

    gl.glTranslatef(MathFP.toFP(0), MathFP.toFP(0), MathFP.toFP(directionY)); //scale it down

    //  gl.glTranslatef(0, -6000, MathFP.toFP(-1));

    //gl.glRotatef(xrot, MathFP.toFP(1), MathFP.toFP(1), MathFP.toFP(1));
    gl.glRotatef(xrot, 65536, 65536, 65536);
    gl.glVertexPointer(3, gl.GL_FIXED, 0, vp);
    gl.glTexCoordPointer(2, gl.GL_FIXED, 0, uv);
    gl.glDrawElements(gl.GL_TRIANGLES, elements.length, 0, elements);

    //System.out.println("POLYCOUNT: " + elements.length);
    gl.glFlush();
    xrot -= MathFP.toFP(directionX);
  }

  private void GLInit() {
    if (!GLInitFlag) {
      gl = new GL(this);
      glu = new GLU(gl);

      // gl.glClearColor3f(0,0,0);
      gl.glEnable(gl.GL_DEPTH_TEST);
      gl.glEnable(GL.GL_CULL_FACE);
      gl.glCullFace(GL.GL_BACK);
      resizeScene();
      GLInitFlag = true;
    }
  }

  // http://www.songho.ca/opengl/gl_transform.html
  // GL_PROJECTION is to camera and GL_MODELVIEW is to world objects
  public void resizeScene() {
    gl.glViewport(dx, dy, CSIZEW, CSIZEH);

    gl.glMatrixMode(gl.GL_PROJECTION);
    gl.glLoadIdentity();
    // System.out.println(w+", "+h);

    glu.gluPerspective(MathFP.toFP(45), 
    MathFP.div(MathFP.toFP(CSIZEW), MathFP.toFP(CSIZEH)), 
    12192, //0.125FP
    MathFP.toFP(7000));

    // left, right, bottom, top,  near , far
    //gl.glFrustum(MathFP.toFP(-1), MathFP.toFP(1), MathFP.toFP(-1), MathFP.toFP(1), MathFP.toFP(1), MathFP.toFP(12));//18

    //view
    gl.glRotatef(MathFP.toFP(-0), MathFP.toFP(0), MathFP.toFP(0), MathFP.toFP(1));
    gl.glRotatef(MathFP.toFP(-0), MathFP.toFP(0), MathFP.toFP(1), MathFP.toFP(0));
    gl.glRotatef(MathFP.toFP(-0), MathFP.toFP(1), MathFP.toFP(0), MathFP.toFP(0));
    gl.glTranslatef(MathFP.toFP(-0), MathFP.toFP(-0), MathFP.toFP(-3));

    /* 	gl.frustum(MathFP.toFP(-10), MathFP.toFP(10),
     MathFP.toFP(-6), MathFP.toFP(6),
     MathFP.toFP(1), MathFP.toFP(100)
     );*/
    //gl.glMatrixMode(gl.GL_MODELVIEW);

    gl.glMatrixMode(gl.GL_MODELVIEW);


    gl.glLoadIdentity();

    // model
    gl.glTranslatef(MathFP.toFP(0), MathFP.toFP(0), MathFP.toFP(-3));
    gl.glRotatef(MathFP.toFP(0), MathFP.toFP(1), MathFP.toFP(0), MathFP.toFP(0));
    gl.glRotatef(MathFP.toFP(0), MathFP.toFP(0), MathFP.toFP(1), MathFP.toFP(0));
    gl.glRotatef(MathFP.toFP(0), MathFP.toFP(0), MathFP.toFP(0), MathFP.toFP(1));
  }

  public void render(int[] buffer, int x, int y, int w, int h) {
    // System.out.println("render()");
    GLSample.renderBuffer = buffer;
  }

  public boolean createTextureArray(int[] src, int width, int height) {
    int size = 3 * width * height;
    byte[] data = new byte[size];

    int theCount = 0;
    for (int i = 0; i < size; i += 3) { // reverse all of the colors. (bgr -> rgb)
      data[i] = (byte) ((src[theCount]>>>16));
      data[i + 1] = (byte) ((src[theCount]>>>8));
      data[i + 2] = (byte) (src[theCount]);
      theCount++;
    }

    gl.glTexImage2D(gl.GL_TEXTURE_2D, 0, 3, width, height, 0, 0, 0, data);
    return true;
  }

  private boolean createTexture(String src) {
    System.out.println("createTexture()");
    gl.glEnable(gl.GL_TEXTURE_2D);
    try {
      int width;
      int height;
      System.out.println("createTexture() 1");
      DataInputStream file = new DataInputStream(_class.getResourceAsStream(src));
      System.out.println("createTexture() 2");
      file.skip(18);
      System.out.println("createTexture() 3");
      width = (file.read() << 0) + (file.read() << 8) + (file.read() << 16) + (file.read() << 24);
      height = (file.read() << 0) + (file.read() << 8) + (file.read() << 16) + (file.read() << 24);
      System.out.println("createTexture " + src + " width=" + (width) + " hieght=" + (height));
      int plane = (file.read() << 0) + (file.read() << 8);//+(file.read()<<16)+(file.read()<<24);
      System.out.println("createTexture plane=" + plane);
      int bpp = (file.read() << 0) + (file.read() << 8);
      System.out.println("createTexture bpp=" + bpp);
      file.skip(24);
      int size = 3 * width * height;
      byte[] data = new byte[3 * width * height];
      file.read(data);
      file.close();

      for (int i = 0; i < size; i += 3) { // reverse all of the colors. (bgr -> rgb)
        byte temp = data[i];
        data[i] = data[i + 2];
        data[i + 2] = temp;
      }

      gl.glGenTextures(1, tex);
      gl.glBindTexture(gl.GL_TEXTURE_2D, tex[0]);
      gl.glTexImage2D(gl.GL_TEXTURE_2D, 0, 3, width, height, 0, 0, 0, data);
    } 
    catch (Exception x) {
      x.printStackTrace();
      return false;
    }
    ;
    return true;
  }

  private boolean loadMds(String src) {
    try {
      DataInputStream mds = new DataInputStream(_class.getResourceAsStream(src));

      byte[] header = new byte[4];
      mds.read(header);
      if (header[0] != 0x6D || header[1] != 0x64 || header[2] != 0x73 || header[3] != 0) {
        System.out.println("loadMds invalid mds header !!!");
        return false;
      }

      int vplength = mds.readInt();
      vp = new int[vplength];
      for (int lo = 0; lo < vplength; lo++) {
        vp[lo] = mds.readInt();
        //	vp[lo]=MathFP.div(vp[lo],MathFP.toFP(100));
      }

      int uvlength = mds.readInt();
      uv = new int[uvlength];
      for (int lo = 0; lo < uvlength; lo++) {
        uv[lo] = mds.readInt();
      }

      int ellength = mds.readInt();
      int elbit = mds.read();
      elements = new int[ellength];
      if (elbit != 32) {
        System.out.println("loadMds invalid elements bit !!! " + elbit);
        return false;
      }
      for (int lo = 0; lo < ellength; lo++) {
        elements[lo] = mds.readInt();
      }
      System.out.println("loadMds elements.length=" + elements.length);
      mds.close();
    } 
    catch (Exception x) {
      x.printStackTrace();
      return false;
    }
    ;
    return true;
  }
}

