/*
 * This class changes the alpha value of an image array.
 * All the pixels in the image contains Alpha, Red, Green, Blue (ARGB) colors
 * where each of the color is a value from 0 to 255.
 * If Alpha is 255 the pixel will be opaque, if its 0 the pixel is transparent.
 * 0xFFFF0000 = 11111111 11111111 00000000 00000000 - this is a red opaque pixel.
 *
 * To get the RGB values from the array we can use the AND '&' operator.
 * (11111101 & 01111110) = 01111100, only the 1:s where & = 1 will get through.
 *
 * to change 11111111 to 11111111 00000000 00000000 00000000 we can use the
 * shift left operator '<<', (00000001 << 7) = 10000000 in dec (1<<7) = 128
 *
 * To change the alpha value we loop through all the pixels in the image.
 *
 * With the blend method its also possible to mask and dontmask specific colors.
 */
package demoplatform.GL;

import demoplatform.Demoplatform;
import java.awt.Color;
import java.awt.Graphics;

public class Fade extends Demoplatform {

    //GLOBALS
    int alphavalue;
    long starttime;
    float count_up;
    float count_down;
    float calc_alpha;  // transparency amount distributed over time
    public boolean fadeInFlag = false;
    public boolean fadeOutFlag = false;
    public boolean fadeInComplete = false;
    public boolean fadeOutComplete = false;

    public void Fade() {
    }

    public void fadeIn(Graphics g, int duration, int fadeInColor) {

        if (fadeInFlag == false) {
            starttime = System.currentTimeMillis();
            fadeInFlag = true;
            alphavalue = 0;
        }

        if (fadeInFlag) {
            if (alphavalue < 255) {
                count_up = (System.currentTimeMillis() - starttime); // timer count since (mousePressed())
                count_down = duration - count_up; // countdown since started (mousePressed())
                calc_alpha = 255 / (duration / count_up); // fade-in, calculate alpha value vs. duration
                alphavalue = MathFP.clamp((int) calc_alpha, 0, 255);

            } else {
                fadeInComplete = true;
            }


                g.setColor(new Color(fadeInColor >> 16 & 0xFF, fadeInColor >> 8 & 0xFF, fadeInColor & 0xFF, alphavalue));
                g.fillRect(0, 0, w, h);

        }
    }

    public void fadeOut(Graphics g, int duration, int fadeOutColor) {
        if (fadeOutFlag == false) {
            starttime = System.currentTimeMillis();
            fadeOutFlag = true;
            alphavalue = 255;
        }

        if (fadeOutFlag) {
            if (alphavalue > 0) {
                count_up = (System.currentTimeMillis() - starttime); // timer count since (mousePressed())
                count_down = duration - count_up; // countdown since started (mousePressed())
                calc_alpha = 255 / (duration / count_down); // fade-out, calculate alpha value vs. duration
                //alphavalue = floor(calc_alpha); // floor rounds DOWN and returns the closest integer value
                //alphavalue = MathFP.floor((int) calc_alpha); //ceil(calc_alpha); // ceil rounds UP and returns the closest integer value
                alphavalue = MathFP.clamp((int) calc_alpha, 0, 255);
                //g.setColor(new Color(0, 0, 0, alphavalue));


            } else {
                fadeOutComplete = true;
            }

                g.setColor(new Color(fadeOutColor >> 16 & 0xFF, fadeOutColor >> 8 & 0xFF, fadeOutColor & 0xFF, alphavalue));
                g.fillRect(0, 0, w, h);
        }
    }

    // raw is the image array.
    public static void blend(int[] raw, int alphaValue, int maskColor, int dontmaskColor) {
        int len = raw.length;

        // Start loop through all the pixels in the image.
        for (int i = 0; i < len; i++) {
            int a = 0;
            int color = (raw[i] & 0x00FFFFFF); // get the color of the pixel.
            if (maskColor == color) {
                a = 0;
            } else if (dontmaskColor == color) {
                a = 255;
            } else if (alphaValue > 0) {
                a = alphaValue;     // set the alpha value we vant to use 0-255.
            }

            a = (a << 24);    // left shift the alpha value 24 bits.
            // if color = 00000000 11111111 11111111 00000000
            // and alpha= 01111111 00000000 00000000 00000000
            // then c+a = 01111111 11111111 11111111 00000000
            // and the pixel will be blended.
            color += a;
            raw[i] = color;
        }
    }

    public static void blend(int[] raw, int alphaValue) {
        blend(raw, alphaValue, 0xFFFFFFFF, 0xFFFFFFFF);
    }
}
