/*

Name      :  Fire
Notes     :  Flames rising up the screen

The fire effect has been used quite often for oldskool demos.
First you create a palette of 256 colors ranging from red to
yellow (including black). For every frame, calculate each row
of pixels based on the two rows below it: The value of each pixel,
becomes the sum of the 3 pixels below it (one directly below, one
to the left, and one to the right), and one pixel directly two
rows below it. Then divide the sum so that the fire dies out
as it rises.

optimized pixel addition and added perlin noise to make fire more natural looking

references:
http://www.student.kuleuven.be/~m0216922/CG/fire.html

 */
package demoplatform;

import demoplatform.GL.Noise3;
import java.util.Random;

public class Fire extends Demoplatform {

    double ns = 0.015;  //increase this to get higher density
    double tt = 0;
    public static int[] fire_buffer;
    int[] flame_palette;
    // cycle through fire lookup array
    int pong;
    int pongDir = 1;
    int[] tile;    // perlin noise lookup table
    int rwQ;
    int rhQ;
    int widthLeft;
    int widthRight;
    int fire_length;
    public Random generator = new Random();
    //Need an array (for RGB, with the size of original image)
    //int rgb[];

    // constructor
    public Fire() {
        debug("Fire():: initialize");
        flame_palette = new int[256];
        fire_length = rw * rh;
        widthLeft = rw - 1;
        widthRight = rw + 1;
        fire_buffer = new int[fire_length + widthRight];

        debug("Fire():: generate flame color palette");
        // generate flame color palette in RGB. need 256 bytes available memory
        for (int i = 0; i < 64; i++) {

            /*
            flame_palette[i] = color(i << 2, 0, 0, 255);      // Black to red
            flame_palette[i + 64] = color(255, i << 2, 0, 255); // Red to yellow
            flame_palette[i + 128] = color(255, 255, i << 2, 255); // Yellow to white,
            flame_palette[i + 192] = color(255, 255, 255, 255);   // White
             * */


            flame_palette[i] = color(i << 2, 0, 0, i<<2);      // Black to red
            flame_palette[i + 64] = color(255, i << 2, 0, 255); // Red to yellow
            flame_palette[i + 128] = color(255, 255, i << 2, 255); // Yellow to white,
            flame_palette[i + 192] = color(255, 255, 255, 255);   // White

        }

        tile = makeTile(rw, rh);

        debug("Fire():: end initialize");
    }

// make a seamless tile
    int[] makeTile(int w, int h) {
        int[] tile = new int[w * h];
        Noise3 noise3 = new Noise3();
        for (int x = 0; x < w; x++) {
            for (int y = 0; y < h; y++) {
                //double u = (double) x / w;
                //double v = (double) y / h;

                /*
                double noise00 = noisee.noise(x*ns, y*ns,tt);
                double noise01 = noisee.noise(x*ns, (y+h)*ns,tt);
                double noise10 = noisee.noise((x+w)*ns, y*ns,tt);
                double noise11 = noisee.noise((x+w)*ns, (y+h)*ns,tt);
                 */

                /*
                double noise00 = noise3.noise3((x * ns), (y * ns), 0);
                double noise01 = noise3.noise3(x * ns, (y + h) * ns, tt);
                double noise10 = noise3.noise3((x + w) * ns, y * ns, tt);
                double noise11 = noise3.noise3((x + w) * ns, (y + h) * ns, tt);

                double noisea = u * v * noise00 + u * (1 - v) * noise01 + (1 - u) * v * noise10 + (1 - u) * (1 - v) * noise11;
                 * */

                // int value = (int) (255 * noisea) & 0xFF;


                int value = ((int) (255 * noise3.noise3(x * ns, (y * ns), 0))) & 0xFF;
                int r = value;
                int g = value;
                int b = value;


                if (r > 255) {
                    r = 255;
                }
                if (r < 0) {
                    r = 0;
                }

                if (g > 255) {
                    g = 255;
                }
                if (g < 0) {
                    g = 0;
                }

                if (b > 255) {
                    b = 255;
                }
                if (b < 0) {
                    b = 0;
                }
                tile[x + y * w] = value;//color(r&0xFF,g&0xFF,b&0xFF);
            }
        }
        return tile;
    }

    void draw(int[] renderBuffer) {

        pong += pongDir;

        if (pong >= rh) {
            pongDir = -1;
            pong = rh - 1;
        }

        if (pong < 1) {
            pongDir = 1;
            pong = 0;
        }

        // look up table - should be fastest
        System.arraycopy(tile, pong * rw, fire_buffer, fire_length, rw);

        for (int currentPixelIndex = 0; currentPixelIndex < fire_length; currentPixelIndex++) {
            // Add pixel values around current pixel
            // Output everything to screen using our palette colors
            fire_buffer[currentPixelIndex] =
                    (((fire_buffer[currentPixelIndex] + fire_buffer[currentPixelIndex + widthLeft] + fire_buffer[currentPixelIndex + rw] + fire_buffer[currentPixelIndex + widthRight])) >> 2) - 1;

            if (fire_buffer[currentPixelIndex] < 0) {
                fire_buffer[currentPixelIndex] = 0;
            }
            renderBuffer[currentPixelIndex] = flame_palette[fire_buffer[currentPixelIndex]];
        }
    }
}


