/*

 Name      :  Distort
 Notes     :  RGB shaking 
 
 reference:
 http://www.bennyschuetz.com/2011/slidely-distorted/
 */
package demoplatform;

import demoplatform.GL.MathFP;

public class Distort extends Demoplatform {

  int[] currentImageData;
  int currentImageDataLength;

  // Distort logo
  int barY1 = 10;
  int barY2 = 20;
  public float jump = 0;

  // constructor
  public Distort() {
    debug("Distort():: initialize");
    currentImageDataLength = (rw * rh) - 1;
    debug("Distort():: end initialize");
  }

  void draw(int[] renderBuffer) {
    int i = 0;
    int offRed, offGreen, offBlue;
    int colDiv;
    offRed = (int) (Math.random() * 3) * 2;
    offGreen = (int) (Math.random() * 3) * 2;
    offBlue = (int) (Math.random() * 3) * 2;

    if (barY2 > (rh / 2)) {
      barY1 = 10;
      barY2 = 20;
    }

    barY1 += 1;
    barY2 += 1;
    for (int y = 1; y < rh / 2; y++) {
      colDiv = (y < barY2 && y > barY1) ? 50 : 0; // vertically moving horizonal strip
      int strips = ((y % 2) * 16);
      for (int x = 0; x < rw / 2; x++) {
        int imagePixelR = currentImageData[i + offRed] >> 16 & 0xFF - colDiv;
        int imagePixelG = currentImageData[i + offGreen] >> 8 & 0xFF - colDiv;
        int imagePixelB = currentImageData[i + offBlue] & 0xFF - colDiv;

        imagePixelR = MathFP.clamp(imagePixelR - strips, 0, 255); // equivalent to red(currentPixel);
        imagePixelG = MathFP.clamp(imagePixelG - strips, 0, 255); // equivalent to red(currentPixel);
        imagePixelB = MathFP.clamp(imagePixelB - strips, 0, 255); // equivalent to red(currentPixel);
        renderBuffer[i++] = color(imagePixelR, imagePixelG, imagePixelB, 255);
      }
      //  i = i + (rw * 2);
    }
  }

  public void draw(int[] renderBuffer, int[] currentImageData, int shake) {
    int i = 0;
    int offRed, offGreen, offBlue;
    int colDiv;
    offRed = (int) (Math.random() * (shake + jump)) * 2;
    offGreen = (int) (Math.random() * (shake + jump)) * 2;
    offBlue = (int) (Math.random() * (shake + jump)) * 2;

    jump *= 0.8;
    if (jump <= 0.01F) {
      jump = 0;
    }

    if (barY2 > (rh)) {
      barY1 = 0;
      barY2 = 30;
    }

    barY1 += 3;
    barY2 += 3;
    for (int y = 0; y < rh; y++) {
      colDiv = (y < barY2 && y > barY1) ? 15 : 0; // vertically moving horizonal strip
      int strips = ((y % 2) * 64);
      for (int x = 0; x < rw; x++) {
        //colDiv = colDiv;
        int imagePixelR = (currentImageData[MathFP.clamp(i + offRed, 0, currentImageDataLength)] >> 16 & 0xFF) - colDiv;
        int imagePixelG = (currentImageData[MathFP.clamp(i + offGreen, 0, currentImageDataLength)] >> 8 & 0xFF) - colDiv;
        int imagePixelB = (currentImageData[MathFP.clamp(i + offBlue, 0, currentImageDataLength)] & 0xFF) - colDiv;
        int imagePixelA = (currentImageData[MathFP.clamp(i + offRed, 0, currentImageDataLength)] >> 24 & 0xFF);
        renderBuffer[i++] = color(MathFP.clamp(imagePixelR - strips, 0, 255), MathFP.clamp(imagePixelG - strips, 0, 255), MathFP.clamp(imagePixelB - strips, 0, 255), imagePixelA);
      }
      //  i = i + (rw * 2);
    }
  }

  void drawFast(int[] renderBuffer, int[] currentImageData, int shake) {
    int i = 0;
    int offRed, offGreen, offBlue;
    offRed = (int) (Math.random() * (shake + jump)) * 2;
    offGreen = (int) (Math.random() * (shake + jump)) * 2;
    offBlue = (int) (Math.random() * (shake + jump)) * 2;

    jump -= 0.8;
    if (jump < 0) {
      jump = 0;
    }
    int brighten = (int) (jump * 20);

    for (int y = 0; y < rh; y++) {
      int strips = ((y % 2) * 16);
      for (int x = 0; x < rw; x++) {
        int imagePixelR = brighten + (currentImageData[MathFP.clamp(i + offRed, 0, currentImageDataLength)] >> 16 & 0xFF);
        int imagePixelG = brighten + (currentImageData[MathFP.clamp(i + offGreen, 0, currentImageDataLength)] >> 8 & 0xFF);
        int imagePixelB = brighten + (currentImageData[MathFP.clamp(i + offBlue, 0, currentImageDataLength)] & 0xFF);
        int imagePixelA = (currentImageData[i] >> 24 & 0xFF);
        renderBuffer[i++] = color(MathFP.clamp(imagePixelR - strips, 0, 255), MathFP.clamp(imagePixelG - strips, 0, 255), MathFP.clamp(imagePixelB - strips, 0, 255), imagePixelA);
      }
    }
  }
}

