/*

 Name      :  Disolve
 Notes     :  burn transition
 
 based on code from
 http://wonderfl.net/c/yFSI/
 
 */
package demoplatform;

import demoplatform.GL.Noise3;
import java.util.LinkedList;

public class Disolve extends Demoplatform {

  float[] croud;       
  boolean[] prevMask;  
  boolean[] curMask;
  boolean[] diff;      
  boolean[] noiseMask; 
  float t;             
  public int[] bgImg;  
  public int[] fgImg;  
  int[] croudMask;    
  int[][] img;      
  final int N_IMG = 1; 
  int imgIndex;
  int width;
  int height;
  LinkedList particleList; 
  int pixelIndexLength;

  // constructor
  public Disolve() {
    debug("Disolve():: initialize");


    bgImg = getImageArray("/images/back.png");

    img = new int[N_IMG][];
    for (int i = 0; i < N_IMG; i++) {
      img[i] = getImageArray("/images/t" + i + ".png");
    }
    imgIndex = 0;
    width = rw;
    height = rh;

    fgImg = new int[width * height]; //createImage(width, height, RGB);

    croud = new float[width * height];
    prevMask = new boolean[width * height];
    curMask = new boolean[width * height];
    diff = new boolean[width * height];
    noiseMask = new boolean[width * height];

    particleList = new LinkedList();

    croudMask = new int[width * height]; //createImage(width, height, RGB);
    initData(img[imgIndex]);
    debug("Disolve():: end initialize");
  }

  private void initData(int[] _img) {
    particleList.clear();
    createCroud();
    createCroudMask(_img);

    t = 0;
    for (int y = 0; y < height; y++) {
      for (int x = 0; x < width; x++) {
        int index = y * width + x;
        boolean isBackground = (croudMask[y * width + x] & 0xFF) < 0x80;
        if (isBackground) {
          croud[index] = 0xFF000000;
        }
        prevMask[index] = curMask[index] = croud[index] < t;
        if (Math.random() > 0.90) {
          noiseMask[index] = !isBackground;
        }
      }
    }
    imgIndex = ++imgIndex < N_IMG ? imgIndex : 0;
  }

  private void createCroudMask(int[] _img) {
    if (_img != null) {
      float angle = 20;

      int _maskImgwidth = width;
      int _maskImgheight = height;

      int[] _maskImg = new int[width * height];

      for (int y = 0; y < _maskImgheight; y++) {
        for (int x = 0; x < _maskImgwidth; x++) {
          _maskImg[y * _maskImgwidth + x] = 0xFFFFFFFF;
        }
      }

      //image(_maskImg, 0, 0);

      for (int y = 0; y < height; y++) {
        for (int x = 0; x < width; x++) {
          croudMask[y * width + x] = _maskImg[y * width + x];
        }
      }

      renderBuffer = _img;

      for (int y = 0; y < height; y++) {
        for (int x = 0; x < width; x++) {
          fgImg[y * width + x] = _img[y * width + x];
        }
      }
    }
  }

  private void createCroud() {
    if (croud == null) {
      croud = new float[width * height];
    }


    float bias = 150.0f;
    float xbase = (float) Math.random() * 100;
    float ybase = (float) Math.random() * 100;

    float xnoise = 0.0f;
    float ynoise = 0.0f;
    float inc = 0.02f;

    Noise3 noise3 = new Noise3();


    bias = Math.min(bias, 0xFF);
    for (int y = 0; y < height; y++) {
      float curBias = y * bias / height;
      for (int x = 0; x < width; x++) {

        float _gray = (int) (noise3.noise3((xnoise + xbase), (ynoise + ybase), 0) * (0xFF - bias) + curBias);
        croud[y * width + x] = _gray;
        xnoise += inc;
      }
      xnoise = 0.0f;
      ynoise += inc;
    }
  }

  void draw(int[] renderBuffer) {
    for (int y = 0; y < height; y++) {
      for (int x = 0; x < width; x++) {
        int index = y * width + x;
        curMask[index] = croud[index] < t;
        diff[index] = prevMask[index] != curMask[index];
        prevMask[index] = curMask[index];

        if (curMask[index]) {
          renderBuffer[index] = bgImg[index];
        } 
        else {
          renderBuffer[index] = fgImg[index];
        }

        if (diff[index]) {
          renderBuffer[index] = 0xFFFFFFFF;  
          if (noiseMask[index]) {
          }
        }
      }
    }
    t+=4;
  }
}

