/*
 Name      : Funky Fresh
 Author    : Luis Gonzalez - lobster@luis.net
 Compo     : Wild Demo                                      
 Platform  : Bluray Java - Java 2 Micro Edition
 Memory    : 12MB - some players have less 8MB 
 Hardware  : Any fast bluray player such as a SONY, PS3 or PC Player
 Released  : April 7, 2012 @ Revision 2012 Party
 
 This file combines all effects into a time based demo with sound synchronization. 
 Tested on Total Media Theatre 3, Playstation 3 and PowerDVD.  Performance will vary per player.  
 To compile this project you need to apply for BD-J docstubs and Java ME Platform SDK v3.0
 
 */
package demoplatform;

import demoplatform.GL.Fade;
import demoplatform.GL.MathFP;
import demoplatform.scenes.Hypnotoad;
import java.awt.*;
import javax.media.*;
import org.bluray.ui.event.HRcEvent;
import org.dvb.event.UserEventListener;
import org.dvb.ui.*;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import org.havi.ui.HScene;
import org.havi.ui.HSceneFactory;
import java.awt.Dimension;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.util.Arrays;
import javax.media.Manager;
import javax.media.Player;
import javax.tv.xlet.Xlet;
import javax.tv.xlet.XletContext;
import org.bluray.net.BDLocator;
import org.bluray.ui.BDVideoConfigTemplate;
import org.davic.media.MediaLocator;
import org.davic.resources.ResourceClient;
import org.davic.resources.ResourceProxy;
import org.dvb.event.EventManager;
import org.dvb.event.UserEvent;
import org.dvb.event.UserEventRepository;
import org.havi.ui.HGraphicsConfigTemplate;
import org.havi.ui.HGraphicsConfiguration;
import org.havi.ui.HGraphicsDevice;
import org.havi.ui.HScreen;
import org.havi.ui.HScreenConfigTemplate;
import org.havi.ui.HVideoConfiguration;
import org.havi.ui.HVideoDevice;

public class Demoplatform extends Container implements Xlet, Runnable, UserEventListener, ResourceClient {

  public volatile boolean isBusy = false;
  static String debugMessage = "nothing";
  int part = 1;                     // which part of demo to start from
  static final int mspf = 33;       // 40=25fps   16=60FPS
  int fps = 1;              // used for debugging
  int longTick = 48000;
  int tick = longTick;              // how long each effect runs
  long time = 0;
  long last = 0;
  long beginTime = 0;
  int frame = 0;
  int currentTime = 0;
  private HScene scene;
  private XletContext context;
  private Thread myWorkerThread;
  private boolean running = true;
  //private Font font;
  //static PNG generatePNG;
  //MemoryImageSource mis;
  //Image displayImage;
  DVBBufferedImage buffer = null;  // tiny framebuffer effects
  DVBBufferedImage buffer2 = null; // final image to screen
  DVBBufferedImage bufferImg = null;


  DVBBufferedImage titleImg = null;

  //Image bufferImage;
  Graphics2D graphics, buffer2Graphics;
  static int renderBuffer[];  //performance hit
  int renderBuffer2[];  //performance hit
  //static int render3DBuffer[];  //performance hit
  private Player player = null;
  public static int directionX = 1;
  public static int directionY = -1;
  // list of effects
  Intro introEffect;
  Rotozoomer rotozoomerEffect;
  public Fire fireEffect;
  Snow snowEffect;
  Plasma plasmaEffect;
  PlasmaNew plasmaNewEffect;
  Star starEffect;
  Deform deformEffect;
  Vectorball vectorballEffect;
  GLSample GLSampleEffect;
  Voxel voxelEffect;
  Rasterbar rasterbarEffect;
  Sinescroller sineScrollerEffect;
  Amigaball amigaBallEffect;
  Lens lensEffect;
  Rays raysEffect;
  Twister twisterEffect;
  Wormhole wormholeEffect;
  Disolvemask disolveEffect;
  Fade fadeEffect;
  Distort distortEffect;
  Animation animation1;
  // list of scenes
  Hypnotoad hypnotoadEffect;


  /* List of avaiable resolutions for Graphics mode to switch to
   * SD_60HZ_720_480
   * SD_50HZ_720_576
   * 720p = 1280_720
   * 1080p = 1920_1080
   * qHD = 960x540
   */
  public int w = 960;
  public int h = 540;
  public int rw = w / 2;
  public int rh = h / 2;

  // tv events in seconds
  int[] beats = {
    1317, 
    2418, 
    3809, 
    4161, 
    5033, 
    5356, 
    6976, 
    7833, 
    9142, 
    9800, 
    10472, 
    12572, 
    13101, 
    14623, 
    15720, 
    17639, 
    19162, 
    19545, 
    20388, 
    20703, 
    22182, 
    193202, 
    293202, 
    393202
  };
  int beatCounter = 0;
  int snareCounter = 0;
  int[] introSnare = {
    22651, 
    23572, 
    24494, 
    25414, 
    26342, 
    27265, 
    28187, 
    28762, 
    29100, 
    30036, 
    30956, 
    31879, 
    32800, 
    33728, 
    34650, 
    36953
  };
  int[] snare = {
    /* twister
     67415,
     69268,
     71116,
     74803,
     76651,
     78501,
     80347,
     82185,
     84034,
     85884,
     87732,
     89573,
     91881,
     93267,
     */
    96958, 
    98801, 
    100649, 
    102493, 
    104338, 
    106184, 
    108034, 
    111721, 
    113571, 
    115415, 
    117260, 
    119108, 
    120954, 
    122800, 
    124645, 
    126491, 
    128342, 
    130182, 
    132030, 
    133876, 
    135722, 
    137567, 
    139415, 
    141261, 
    144960, 
    146810, 
    148649, 
    150494, 
    152347, 
    154193, 
    156034, 
    157879, 
    159730
  };
  int snareCounter2 = 0;

  public Demoplatform() {
  }

  public void initXlet(XletContext context) throws javax.tv.xlet.XletStateChangeException {
    try {
      //add input  event
      UserEventRepository userEventRepo = new UserEventRepository("evt");
      userEventRepo.addAllArrowKeys();
      userEventRepo.addAllColourKeys();
      userEventRepo.addAllNumericKeys();
      userEventRepo.addKey(HRcEvent.VK_ENTER);
      userEventRepo.addKey(HRcEvent.VK_POPUP_MENU);
      EventManager.getInstance().addUserEventListener(this, userEventRepo);
    } 
    catch (Exception e) {
      //error = e.getMessage();
    }

    this.context = context;

    //font = new Font(null, Font.PLAIN, 28);

    scene = createHScene(w, h);
    //scene = HSceneFactory.getInstance().getDefaultHScene();

    setSize(rw, rh); // BD screen size

    scene.setRenderMode(0); //0 is IMAGE_NONE

    //scene.setBackgroundMode(scene.BACKGROUND_FILL);
    scene.setBackgroundMode(HScene.NO_BACKGROUND_FILL);
    //scene.setBackground(new Color(0, 255, 0));

    scene.setSize(w, h);
    scene.validate();
  }

  /*
    public void debugRender(Graphics g) {
   //Graphics g = debugContainer.getGraphics();
   
   Runtime runTime = Runtime.getRuntime();
   //        g.setColor(new Color(0, 0, 0));
   //        g.fillRect(0, 0, 400, h);
   
   // print debug info
   g.setFont(font);
   g.setColor(new Color(0, 255, 0));
   //g.drawString("FPS: " + fps, 50, 50);
   g.drawString("Part: " + part, 50, 100);
   g.drawString("Total Memory: " + runTime.totalMemory() / 1000000, 50, 150);
   g.drawString("Free Memory: " + runTime.freeMemory() / 1000000, 50, 200);
   g.drawString("Used Memory: " + (runTime.totalMemory() - runTime.freeMemory()) / 1000000, 50, 250);
   g.drawString("isBusy: " + isBusy + " " + time, 50, 300);
   g.drawString("Media Time: " + getMediaTimeMS(player), 50, 350);
   g.drawString("Debug: " + debugMessage, 50, 400);
   }
   */


  /**
   * Returns the current media time in ms, or -1 if no playlist has
   * started.
   **/
  public long getMediaTimeMS(Player p) {
    //   Player p = thePlayer;
    if (p == null) {
      return -1;
    } 
    else {
      return (p.getMediaNanoseconds() / 1000000) - 2000;
    }
  }

  public void playSound(String sound) {
    try {
      // Create a MediaLocator for the sound.
      javax.media.MediaLocator locator = new javax.media.MediaLocator(sound);
      // Create a JMF Player for the sound.
      Player soundPlayer = Manager.createPlayer(locator);
      if (soundPlayer != null) {
        // Play the sound.
        soundPlayer.start();
      }
    } 
    catch (Exception exception) {
    }
  }

  private HScene createHScene(int width, int height) {
    Dimension resolution = new Dimension(width, height);
    HGraphicsDevice graphicsDev = HScreen.getDefaultHScreen().getDefaultHGraphicsDevice();

    graphicsDev.reserveDevice(this);

    HGraphicsConfiguration currConfig = graphicsDev.getCurrentConfiguration();
    Dimension currentResolution = currConfig.getPixelResolution();
    debug("createHScene()::currentResolution: " + currentResolution);
    try {
      // Prepare template with new resolution
      HGraphicsConfigTemplate template = new HGraphicsConfigTemplate();
      template.setPreference(HScreenConfigTemplate.PIXEL_RESOLUTION, resolution, HScreenConfigTemplate.REQUIRED);

      // template.setPreference(HScreenConfigTemplate.ZERO_GRAPHICS_IMPACT, null, HScreenConfigTemplate.REQUIRED);
      //  template.setPreference(HScreenConfigTemplate.ZERO_VIDEO_IMPACT, null, HScreenConfigTemplate.REQUIRED);

      // KEEP_RESOLUTION - dont change 1080p video res to media resoltion
      BDVideoConfigTemplate template2 = new BDVideoConfigTemplate();
      HVideoDevice device = HScreen.getDefaultHScreen().getDefaultHVideoDevice();
      template2.setPreference(BDVideoConfigTemplate.KEEP_RESOLUTION, new Object(), BDVideoConfigTemplate.REQUIRED);
      HVideoConfiguration config = device.getBestConfiguration(template2);
      device.reserveDevice(this);
      device.setVideoConfiguration(config);

      // Retrieve best configuration
      HGraphicsConfiguration bestConfig = graphicsDev.getBestConfiguration(template);

      // apply the configurations
      if (bestConfig != null) {
        boolean result = graphicsDev.setGraphicsConfiguration(bestConfig);
        if (result) {
          debug("createHScene():: HGraphicsConfiguration was changed sucessfully");
        } 
        else {
          warning("createHScene():: Unable to change HGraphicsConfiguration, result was false. Target config: ");
        }
      } 
      else {
        warning("createHScene():: Unable to retrieve HGraphicsConfiguration with resolution " + resolution);
      }
    } 
    catch (Exception e) {
      warning("createHScene():: Could not change the graphics resolution to " + resolution + " The following exception occured:");
      //e.printStackTrace();
      warning(e.getMessage());
    }

    return HSceneFactory.getInstance().getFullScreenScene(graphicsDev);
  }

  public void debug(String msg) {
    debugMessage = msg;
    System.out.println(msg);
  }

  public void warning(String msg) {
    debugMessage = msg;
    System.out.println(msg);
  }

  public synchronized void controllerUpdate(ControllerEvent event) {
    if (event instanceof EndOfMediaEvent) {
      // On PC players, this causes a noticable pause in
      // the xlet.  To get around this, we just made the
      // playlist we're playing repeat the same video clip
      // of a starfield over and over again, for a total length
      // of an hour or two.  As a result, it's very unlikely
      // a viewer will see anything other than seamless video.
    }
    notifyAll();
    // When waiting for starting, we just poll the player status,
    // so no matter the event we notifyAll().
  }

  // ResourceClient
  public void notifyRelease(ResourceProxy proxy) {
  }

  public void release(ResourceProxy proxy) {
  }

  public boolean requestRelease(ResourceProxy proxy, Object requestData) {
    return false;
  }

  public void startXlet() {
    setVisible(true);
    scene.setVisible(true);
    requestFocus();

    time = System.currentTimeMillis();
    last = time;

    myWorkerThread = new Thread(this);

    renderBuffer = new int[rw * rh];

    checkOffscreenImage2();

    //generatePNG = new PNG();
    //run();
    //myWorkerThread.setPriority(myWorkerThread.MAX_PRIORITY);
    myWorkerThread.start();
  }

  public void pauseXlet() {
    setVisible(false);
  }

  public void destroyXlet(boolean unconditional) {
    scene.remove(this);
    scene = null;
  }

  public void run() {

    tick();

    debug("run():: BEGIN!!!!");

    /*
         *
     * You can use ADA (Application Data Area).
     BD-J has playing bdmv format (PCM 48~KHz 16bit Signed BE, 4MB max) capability.
     On the PS3 BD-J environment, JMF player is able to play a bdmv file in ADA.
     
     java -jar soundgen.jar sound0.wav sound1.wav ... sound.bdmv
     
     java -cp soundgen.jar;tritonus_share-0.3.6.jar;tritonus_remaining-0.3.6.jar
     net.java.bd.tools.BDJSoundGenerator sound0.wav... sound.bdmv
     *
     *
     * */

    //startVideo("bd://SOUND:00");

    startVideo("bd://PLAYLIST:00000"); // this works
    for (;;) {
      if (getMediaTimeMS(player) > 0) {
        break;
      }
    }

    beginTime = System.currentTimeMillis();

    while (running) {

      onTimerTick(currentTime); // no media
      time = (System.currentTimeMillis() - time);
      currentTime = (int) (System.currentTimeMillis() - beginTime);

      if (time <= 0) {
        time = 1;
      }

      //fps = (int) 1000 / (int) time; //dont need FPS

      if (time <= mspf) {
        time = mspf - time;
      } 
      else {
        time = 1;
      }

      if (time > 1) {
        try {
          //Thread.sleep(10);
          Thread.sleep(time);
          //myWorkerThread.sleep(time); //put timehere
        } 
        catch (Exception _ex) {
        }
      }
    }
  }

  public void userEventReceived(UserEvent evt) {
    if (evt.getType() == HRcEvent.KEY_PRESSED) {

      isBusy = true;
      switch (evt.getCode()) {

      case HRcEvent.VK_POPUP_MENU:
        break;

      case HRcEvent.VK_ENTER:

        break;

      case HRcEvent.VK_LEFT:      // go back one effect
        if (part == 12) {
          voxelEffect.frameC = 0;
          voxelEffect.angleSpeed = -45;
          voxelEffect.playerSpeed = 0;
        }
        directionX--;
        break;

      case HRcEvent.VK_RIGHT:     // advance to next part
        if (part == 12) {
          voxelEffect.frameC = 0;
          voxelEffect.angleSpeed = 45;
          voxelEffect.playerSpeed = 0;
        }
        directionX++;

        break;

      case HRcEvent.VK_UP:
        directionY++;
        break;

      case HRcEvent.VK_DOWN:
        directionY--;
        break;

      case HRcEvent.VK_0:
        break;
      case HRcEvent.VK_1:
        break;
      case HRcEvent.VK_2:
        break;

      case HRcEvent.VK_3:
      case HRcEvent.VK_4:
      case HRcEvent.VK_5:
      case HRcEvent.VK_6:
      case HRcEvent.VK_7:
      case HRcEvent.VK_8:
      case HRcEvent.VK_9:
        //messages.add("HRcEvent.VK_numer : " + evt.getCode());
        break;
      }

      directionX = MathFP.clamp(directionX, -5, 5);
      directionY = MathFP.clamp(directionY, -5, 5);

      isBusy = false;
    }
  }

  private void checkOffscreenImage2() {
    Dimension d = getSize();
    if (buffer == null || buffer.getWidth(null) != d.width || buffer.getHeight(null) != d.height) {

      buffer = new DVBBufferedImage(rw, rh, DVBBufferedImage.TYPE_ADVANCED);
      buffer2 = new DVBBufferedImage(w, h, DVBBufferedImage.TYPE_ADVANCED);

      bufferImg = new DVBBufferedImage(w, h, DVBBufferedImage.TYPE_ADVANCED);

      //src is fastest
      graphics = (Graphics2D) scene.getGraphics();
      graphics.setComposite(AlphaComposite.Src);

      // srcOver slow but needed to overlay transparent images
      buffer2Graphics = (Graphics2D) buffer2.getGraphics();
      buffer2Graphics.setComposite(AlphaComposite.SrcOver);
    }
  }

  // execute once before switching to next part
  public void tick() {

    isBusy = true;
    last = System.currentTimeMillis();
    switch (part) {

    case 1: // tv static intro
      titleImg = new DVBBufferedImage(w, h, DVBBufferedImage.TYPE_ADVANCED);
      titleImg.setRGB(0, 0, w, h, getImageArray("/images/art/logo_960.png"), 0, w);  //preload title image for quick transition
      introEffect = new Intro();
      break;

    case 2:
      introEffect = null;
      twisterEffect = new Twister();
      raysEffect = new Rays();
      fadeEffect = new Fade();
      break;

    case 3:
      twisterEffect = null;
      raysEffect = null;
      renderBuffer = new int[rw * rh];
      renderBuffer2 = new int[rw * rh];
      disolveEffect = new Disolvemask();
      fireEffect = new Fire();
      rotozoomerEffect = new Rotozoomer();
      fadeEffect = new Fade();
      hypnotoadEffect = new Hypnotoad();
      hypnotoadEffect.start();
      break;

    case 4:
      titleImg = null;
      renderBuffer2 = null;
      disolveEffect = null;
      break;

    case 5:
      hypnotoadEffect = null;
      bufferImg.setRGB(0, 0, w, h, getImageArray("/images/art/skull_alpha.png"), 0, w);
      deformEffect = new Deform("/images/seamless/tex2_256.png", 7, rw, rh);
      deformEffect.start();
      break;

    case 6:
      fireEffect = null;
      directionX = 3;
      directionY = 0;
      bufferImg.getGraphics().clearRect(0, 0, w, h);
      fadeEffect = new Fade();
      buffer = new DVBBufferedImage(rw, rh);
      renderBuffer = new int[rw * rh];
      sineScrollerEffect = new Sinescroller();
      sineScrollerEffect.draw();
      bufferImg.setRGB(578, 275, 382, 265, getImageArray("/images/pandaCorner.png"), 0, 382);
      //Arrays.fill(renderBuffer, 0x00000000);
      GLSampleEffect = new GLSample(480, 270, "/models/duck.mds", "/models/duck.bmp");
      break;

    case 7:
      directionX = 3;
      directionY = 0;
      fadeEffect = new Fade();
      deformEffect = new Deform("/images/seamless/tex3_256.png", 5, rw, rh);
      deformEffect.start();
      GLSampleEffect = new GLSample(480, 270, "/models/machine.mds", "/models/machine_256.bmp");
      break;

    case 8:
      directionX = 3;
      directionY = 0;
      fadeEffect = new Fade();
      deformEffect = new Deform("/images/seamless/height_256.png", 3, rw, rh); // 2 or 4
      deformEffect.start();
      GLSampleEffect = new GLSample(480, 270, "/models/cube.mds", "/models/cube.bmp");
      plasmaEffect = new Plasma(256, 128);
      vectorballEffect = new Vectorball();
      break;

    case 9:
      directionX = 1;
      directionY = -1;
      GLSampleEffect = null;
      fadeEffect = new Fade();
      amigaBallEffect = new Amigaball(256, 256);
      wormholeEffect = new Wormhole(320, 240);
      break;

    case 10:
      GLSampleEffect = null;
      amigaBallEffect = null;
      wormholeEffect = null;
      fadeEffect = new Fade();
      deformEffect = new Deform("/images/seamless/tex2_256.png", 7, rw, rh); // 2 or 4
      deformEffect.start();
      animation1 = new Animation("/images/intro/nyan2/", 12);
      break;

    case 11:
      fadeEffect = new Fade();
      bufferImg.setRGB(0, 0, w, h, getImageArray("/images/art/TRSI_barb_wire_final.png"), 0, w);
      break;

    case 12:
      animation1 = null;
      deformEffect = null;
      fadeEffect = new Fade();
      voxelEffect = new Voxel();
      break;

    case 13: //lens
      voxelEffect = null;
      fadeEffect = new Fade();
      buffer = new DVBBufferedImage(256, 256);
      renderBuffer = new int[256 * 256];
      lensEffect = new Lens();
      break;

    case 14:
      directionX = 3;
      directionY = 0;
      lensEffect = null;
      fadeEffect = new Fade();
      vectorballEffect = new Vectorball();
      buffer = new DVBBufferedImage(rw, rh);
      renderBuffer = new int[rw * rh];
      starEffect = new Star();
      GLSampleEffect = new GLSample(480, 270, "/models/discplayer.mds", "/models/discplayer_red_tx.bmp");
      deformEffect = new Deform("/images/seamless/height_256.png", 7, rw, rh); /// 5 is nice
      deformEffect.start();
      break;

    case 15:
      directionX = 3;
      directionY = 0;
      starEffect = null;
      fadeEffect = new Fade();
      GLSampleEffect = new GLSample(480, 270, "/models/desire.mds", "/models/desire.bmp");
      break;

    case 16:
      directionX = 3;
      directionY = 0;
      fadeEffect = new Fade();
      GLSampleEffect = new GLSample(480, 270, "/models/trsi2.mds", "/models/trsi2.bmp");
      break;

    case 17:
      GLSampleEffect = null;
      fadeEffect = new Fade();
      bufferImg.setRGB(0, 0, w, h, getImageArray("/images/art/Deja_Vu.png"), 0, w);
      break;

    case 18:
      renderBuffer = new int[rw * rh];
      fireEffect = new Fire();
      fadeEffect = new Fade();
      disolveEffect = new Disolvemask();
      bufferImg.setRGB(0, 0, w, h, getImageArray("/images/art/DesireTrsi.png"), 0, w);
      break;

    case 19:
      fadeEffect = new Fade();
      bufferImg.setRGB(0, 0, w, h, getImageArray("/images/art/FunkyFresh-End.png"), 0, w);
      break;

    default:
      break;
    }

    System.gc();
    isBusy = false;
  }

  // main demo loop
  private void onTimerTick(int songPosition) //EXEN
  {
    time = System.currentTimeMillis();
    int compareTime = currentTime;

    // switch parts every X seconds
    if (!isBusy) {

      switch (part) {
      case 1:
        introEffect.draw(compareTime, renderBuffer, buffer, buffer2Graphics);
        graphics.drawImage(buffer2, 0, 0, null);

        if (compareTime > 36900) {
          part++;
          tick();
          break;
        }

        break;

      case 2:
        twisterEffect.draw((int) time, renderBuffer);
        raysEffect.draw(buffer2Graphics);
        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
        fadeNext(buffer2Graphics, 50000, compareTime);
        graphics.drawImage(buffer2, 0, 0, null);
        break;

      case 3:
        buffer2Graphics.drawImage(titleImg, 0, 0, null);
        fireEffect.draw(renderBuffer);
        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);

        if (compareTime > 60000) {
          rotozoomerEffect.draw(compareTime, renderBuffer2);
          disolveEffect.draw(renderBuffer, renderBuffer2);
        }

        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
        fadeEffect.fadeOut(buffer2Graphics, 400, color(0, 0, 0, 255));
        graphics.drawImage(buffer2, 0, 0, w, h, null);

        if (compareTime > 65552 & hypnotoadEffect.ready) {
          part++;
          tick();
          break;
        }
        break;

      case 4:
        hypnotoadEffect.draw(buffer2Graphics, compareTime);
        graphics.drawImage(buffer2, 0, 0, null);

        if (compareTime > 81928) {
          part++;
          tick();
          break;
        }
        break;

      case 5:
        fireEffect.draw(renderBuffer);
        buffer.setRGB(0, 0, rw, rh, renderBuffer, 0, rw);

        buffer2Graphics.drawImage(buffer, 193, 77, 414, 298, 0, (rh / 2) + 60, (rh / 2) - 60, rh, null);
        buffer2Graphics.drawImage(buffer, 512, 11, 736, 235, rw / 2, (rh / 2) + 60, ((rh / 2) - 60) + rw / 2, rh, null);

        buffer2.getGraphics().drawImage(bufferImg, 0, 0, w, h, null);
        graphics.drawImage(buffer2, 0, 0, w, h, null);

        if (compareTime > 95877) {
          part++;
          tick();
          break;
        }
        break;

      case 6:
        deformEffect.draw((int) time, renderBuffer);

        GLSampleEffect.draw(directionX, directionY);

        /*
                    if (compareTime > snare[snareCounter2]) {
         distortEffect.jump = 7;  // distort on snare
         snareCounter2++;
         }
         distortEffect.drawFast(renderBuffer, renderBuffer, 1);
         * */

        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
        fadeNext(buffer2Graphics, 110276, compareTime);

        //sinescroller + pandavision
        buffer2Graphics.setColor(new Color(0, 0, 0, 80));
        buffer2Graphics.fillRect(0, 440, 960, 58);
        sineScrollerEffect.paint(buffer2Graphics);
        buffer2Graphics.drawImage(bufferImg, 0, 0, w, h, null);
        graphics.drawImage(buffer2, 0, 0, w, h, null);

        break;

      case 7:
        deformEffect.draw((int) time, renderBuffer);
        GLSampleEffect.draw(directionX, directionY);
        /*
                    if (compareTime > snare[snareCounter2]) {
         distortEffect.jump = 7;  // distort on snare
         snareCounter2++;
         }
         distortEffect.drawFast(renderBuffer, renderBuffer, 1);
         * */

        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
        fadeNext(buffer2Graphics, 125475 - 1200, compareTime);

        //sinescroller + pandavision
        buffer2Graphics.setColor(new Color(0, 0, 0, 80));
        buffer2Graphics.fillRect(0, 440, 960, 58);
        sineScrollerEffect.paint(buffer2Graphics);
        buffer2Graphics.drawImage(bufferImg, 0, 0, w, h, null);
        graphics.drawImage(buffer2, 0, 0, w, h, null);
        break;

      case 8:
        deformEffect.draw((int) time, renderBuffer);
        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);

        plasmaEffect.draw((int) time, renderBuffer);
        GLSampleEffect.tex(renderBuffer, 256, 128);

        Arrays.fill(renderBuffer, 0x00000000);
        GLSampleEffect.draw(directionX, 0);

        if (compareTime > snare[snareCounter2]) {
          //                        distortEffect.jump = 7;  // distort on snare
          snareCounter2++;
        }

        vectorballEffect.rotate(buffer2Graphics, -35, -35, true);
        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
        vectorballEffect.rotate(buffer2Graphics, -35, -35, false);
        vectorballEffect.draw(buffer2Graphics, false);

        if (compareTime < 139326) {
          fadeEffect.fadeOut(buffer2Graphics, 400, color(0, 0, 0, 255));
        }

        //sinescroller + pandavision
        buffer2Graphics.setColor(new Color(0, 0, 0, 80));
        buffer2Graphics.fillRect(0, 440, 960, 58);
        sineScrollerEffect.paint(buffer2Graphics);
        buffer2Graphics.drawImage(bufferImg, 0, 0, w, h, null);

        if (compareTime > 139326) {
          fadeEffect.fadeIn(buffer2Graphics, 400, color(0, 0, 0, 0));

          if (fadeEffect.fadeInComplete) {
            part++;
            tick();
            break;
          }
        }

        graphics.drawImage(buffer2, 0, 0, w, h, null);
        break;

      case 9:
        wormholeEffect.draw(renderBuffer);
        buffer.setRGB(0, 0, 320, 240, renderBuffer, 0, 320);
        buffer2Graphics.drawImage(buffer, 0, 0, w, h, 0, 0, 320, 240, null);
        amigaBallEffect.draw((int) time, renderBuffer);
        buffer.setRGB(0, 0, 256, 256, renderBuffer, 0, 256);
        buffer2.getGraphics().drawImage(buffer, amigaBallEffect.ball_x, amigaBallEffect.ball_y, amigaBallEffect.ball_x + 256, amigaBallEffect.ball_y + 256, 0, 0, 256, 256, null);

        //sinescroller + pandavision
        buffer2.getGraphics().drawImage(bufferImg, 0, 0, w, h, null);
        buffer2Graphics.setColor(new Color(0, 0, 0, 80));
        buffer2Graphics.fillRect(0, 440, 960, 58);
        sineScrollerEffect.paint(buffer2Graphics);
        buffer2Graphics.drawImage(bufferImg, 0, 0, w, h, null);

        fadeNext(buffer2Graphics, 160558, compareTime, 400, 400, color(0, 0, 0, 0), color(0, 0, 0, 0)); //1576 duration

        graphics.drawImage(buffer2, 0, 0, w, h, null);
        break;

      case 10:
        deformEffect.draw((int) time, renderBuffer);

        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
        renderBuffer(reescalaArray(animation1.display(6), 71, 40, 480, 270), rw, rh, w, h, buffer, buffer2Graphics);

        if (compareTime > 165532) {
          fadeEffect.fadeIn(buffer2Graphics, 6096, color(255, 255, 255, 255));

          if (fadeEffect.fadeInComplete) {
            part++;
            tick();
            break;
          }
        } 
        else {
          fadeEffect.fadeOut(buffer2Graphics, 400, color(0, 0, 0, 255));
        }

        graphics.drawImage(buffer2, 0, 0, w, h, null);

        break;

      case 11:
        buffer2Graphics.drawImage(bufferImg, 0, 0, w, h, null);
        fadeNext(buffer2Graphics, 184552, compareTime, 800, 800, color(0, 0, 0, 0), color(255, 255, 255, 255)); //1576 duration
        //vectorballEffect.draw(buffer2Graphics);
        graphics.drawImage(buffer2, 0, 0, w, h, null);
        break;

      case 12:
        voxelEffect.draw(renderBuffer);
        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
        fadeNext(buffer2Graphics, 197501, compareTime, 1900, 400, color(255, 255, 255, 255), color(0, 0, 0, 0)); //1576 duration
        graphics.drawImage(buffer2, 0, 0, null);
        break;

      case 13:
        lensEffect.draw(renderBuffer);

        // restore previous background square to avoid entire screen redraw
        //buffer2.getGraphics().drawImage(lensEffect.bufferImg2, lensEffect.oldX, lensEffect.oldY, lensEffect.oldX + 256, lensEffect.oldY + 256, lensEffect.oldX, lensEffect.oldY, lensEffect.oldX + 256, lensEffect.oldY + 256, null);
        buffer2Graphics.drawImage(lensEffect.bufferImg2, 0, 0, null);

        // draw transformed lens arrray
        buffer.setRGB(0, 0, 256, 256, renderBuffer, 0, 256);

        // put transparent bubble image on top
        buffer.getGraphics().drawImage(lensEffect.imgLens, 0, 0, null);

        // put it on screen at a new bounce location
        buffer2.getGraphics().drawImage(buffer, lensEffect.ball_x, lensEffect.ball_y, null);

        lensEffect.bounce();
        fadeNext(buffer2Graphics, 209501, compareTime, 400, 400, color(0, 0, 0, 0), color(255, 255, 255, 255)); //1576 duration

        graphics.drawImage(buffer2, 0, 0, null);

        //graphics.drawImage(lensEffect.imgLens, lensEffect.ball_x, lensEffect.ball_y, 256, 256, null);

        break;

      case 14:  // plasmacube
        starEffect.draw(buffer2Graphics);
        Arrays.fill(renderBuffer, 0x00000000);
        GLSampleEffect.draw(directionX, directionY);
        vectorballEffect.rotate(buffer2Graphics, -35, -35, true);
        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
        vectorballEffect.rotate(buffer2Graphics, -35, -35, false);
        vectorballEffect.draw(buffer2Graphics, false);
        fadeNext(buffer2Graphics, 209501 + 10000, compareTime);
        graphics.drawImage(buffer2, 0, 0, null);
        break;

      case 15:
        deformEffect.draw((int) time, renderBuffer);
        GLSampleEffect.draw(directionX, directionY);
        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
        fadeNext(buffer2Graphics, 209501 + 20000, compareTime);
        graphics.drawImage(buffer2, 0, 0, null);
        break;

      case 16:
        deformEffect.draw((int) time, renderBuffer);
        GLSampleEffect.draw(directionX, directionY);
        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
        fadeNext(buffer2Graphics, 209501 + 30000, compareTime);
        graphics.drawImage(buffer2, 0, 0, null);
        break;

      case 17:
        buffer2.getGraphics().drawImage(bufferImg, 0, 0, w, h, null);
        fadeNext(buffer2Graphics, 249026, compareTime, 2159, 400, color(255, 255, 255, 255), color(0, 0, 0, 0)); //1576 duration
        graphics.drawImage(buffer2, 0, 0, w, h, null);
        break;

      case 18: // final scene
        buffer2Graphics.drawImage(bufferImg, 0, 0, w, h, null);
        fireEffect.draw(renderBuffer);
        renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);

        if (compareTime > 269302 - 4000) {
          disolveEffect.drawSolid(renderBuffer, 0xFF000000);
          renderBuffer(renderBuffer, rw, rh, w, h, buffer, buffer2Graphics);
        }

        fadeNext(buffer2Graphics, 268000, compareTime, 2159, 1000, color(0, 0, 0, 0), color(255, 255, 255, 255)); //1576 duration
        graphics.drawImage(buffer2, 0, 0, w, h, null);
        break;

      case 19:
        buffer2Graphics.drawImage(bufferImg, 0, 0, w, h, null);
        fadeEffect.fadeOut(buffer2Graphics, 2159, color(0, 0, 0, 255));
        graphics.drawImage(buffer2, 0, 0, w, h, null);
        break;

      default: // endless loop goto first effect
        //part = 1;
        break;
      }

      //debugRender(graphics);
      //           graphics.drawImage(buffer2, 0, 0, w, h, null);

      Toolkit.getDefaultToolkit().sync();
    }
  }

  public static void renderBuffer(int[] renderBuffer, int rw, int rh, int w, int h, DVBBufferedImage from, Graphics to) {
    //Image test = generatePNG.toImage(rw, rh, renderBuffer);
    // to.drawImage(test, 0, 0, w, h, null);
    from.setRGB(0, 0, rw, rh, renderBuffer, 0, rw);
    to.drawImage(from, 0, 0, w, h, null);
  }

  public static void renderBuffer(int[] renderBuffer, int rw, int rh, int x, int y, int w, int h, DVBBufferedImage from, Graphics to) {
    //Image test = generatePNG.toImage(rw, rh, renderBuffer);
    // to.drawImage(test, 0, 0, w, h, null);
    from.setRGB(0, 0, rw, rh, renderBuffer, 0, rw);
    to.drawImage(from, x, y, w, h, null);
  }


  // Scales an input rgb image to the destination size.
  public static int[] reescalaArray(int[] ini, int x, int y, int x2, int y2) {
    int out[] = new int[x2 * y2];
    int pixelCount = 0;

    // Scale using nearest neighbor
    for (int yy = 0; yy < y2; yy++) {
      int dy = yy * y / y2;
      for (int xx = 0; xx < x2; xx++) {
        int dx = xx * x / x2;
        out[pixelCount++] = ini[(x * dy) + dx];
      }
    }
    return out;
  }

  /**
   * Called by the xlet subclass once it's loaded all of its assets
   * and it's ready for video to start playing
   **/
  protected void startVideo(String playlist) {
    try {
      MediaLocator stars = new MediaLocator(new BDLocator(playlist));

      player = Manager.createPlayer(stars);
    } 
    catch (Exception ex) {
      /*
            if (Debug.ASSERT) {
       Debug.printStackTrace(ex);
       Debug.assertFail(ex.toString());
       }
       * */
    }
    //player.addControllerListener(this);


    player.realize();
    player.prefetch();


    // wait for 2 seconds

    try {
      //wait(2000);
      Thread.sleep(3000L);
    } 
    catch (InterruptedException ex) {
    }

    debug("startVideo() :: player.start()");

    player.start();

    /*
        for (;;) {
     if (player.getState() == Player.Started) {
     break;
     }
     }
     * */

    waitForStarted(5000);
  }

  //
  // Wait until the state of our player is "started".
  //
  private synchronized boolean waitForStarted(long timeout) {
    long tm = 0;
    if (timeout > 0) {
      tm = System.currentTimeMillis();
    }
    for (;;) {
      if (player.getState() == Player.Started) {
        /*
                if (Debug.LEVEL > 0) {
         Debug.println("Player is in started state");
         }
         * */
        debug("Player is in started state");
        return true;
      }
      if (!waitWithTimeout(tm, timeout)) {
        return false;
      }
    }
  }

  //
  // Wait a bit.  Return true if we got notified, false if we timed out
  // or were interrupted.
  private boolean waitWithTimeout(long startTime, long timeout) {
    try {
      if (timeout <= 0) {
        wait();
        return true;
      } 
      else {
        long t = timeout - (System.currentTimeMillis() - startTime);
        if (t <= 0) {
          return true;
        }
        wait(t);
        t = timeout - (System.currentTimeMillis() - startTime);
        return t > 0;
      }
    } 
    catch (InterruptedException ex) {
      Thread.currentThread().interrupt();
      return false;
    }
  }

  public Image getImage(String imagePath) {
    debug("getImage():: before..");
    //        Image image = Toolkit.getDefaultToolkit().getImage(getClass().getResource(imagePath));

    Image image = Toolkit.getDefaultToolkit().createImage(getClass().getResource(imagePath));
    //Image image = Toolkit.getDefaultToolkit().getImage(getClass().getClassLoader().getResource(imagePath));
    //Image image = this.getToolkit().getImage(getClass().getResource(imagePath));
    debug("getImage():: done..");
    return image;
  }

  public int[] getImageArray(String imagePath) {

    ImageLoader texLoader = new ImageLoader(imagePath, true, this);
    texLoader.load();

    debug("getImageArray():: wait for " + imagePath);
    while (!texLoader.ready ()) {
      try {
        Thread.sleep(100L);
      } 
      catch (Exception _ex) {
      }
    }
    return (int[]) texLoader.getPixels();
  }

  public int[] getImageArrayOld(String imagePath) {
    Image image = getImage(imagePath);

    ImageObserver dummy = new ImageObserver() {

      public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
      }
    };

    PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, image.getWidth(null), image.getHeight(null), true); // true is for alpha
    try {
      debug("getImageArray():: grab pixels");
      pixelgrabber.grabPixels();
    } 
    catch (InterruptedException ex) {
      debug("getImageArray():: problem with pixelgrabber" + ex.toString());
    }


    Object stuff = pixelgrabber.getPixels();
    return (int[]) stuff;
  }

  /*
    In Java, images are generally represented using the 32-bit ARGB8888 format.
   In this format, each component (Alpha/Red/Green/Blue) is represented by an 8-bit number (0 to 255).
   The four components are packed into a 32-bit number.
   */
  public int color(int r, int g, int b) {
    return (r << 16) | (g << 8) | b;
  }

  // with alpha
  public int color(int r, int g, int b, int a) {
    return (a << 24) | (r << 16) | (g << 8) | b;
  }

  // greyscale
  public int color(int r) {
    return (r << 16) | (r << 8) | r;
  }

  public int addColor(int c1, int c2) {
    //int a1 = (c1 >> 24) & 0xff;
    int r1 = (c1 >> 16) & 0xFF;
    int g1 = (c1 >> 8) & 0xFF;
    int b1 = c1 & 0xFF;

    int r2 = (c2 >> 16) & 0xFF;
    int g2 = (c2 >> 8) & 0xFF;
    int b2 = c2 & 0xFF;

    int r = r1 + r2 < 0xFF ? r1 + r2 : 0xFF;
    int g = g1 + g2 < 0xFF ? g1 + g2 : 0xFF;
    int b = b1 + b2 < 0xFF ? b1 + b2 : 0xFF;

    return (0xFF << 24 | r << 16 | g << 8 | b);
  }

  public byte colorIndex(int r, int g, int b) {
    return (byte) (((b & 255 & 0xC0) + ((g & 255 & 0xE0) >> 2) + ((r & 0xE0) >> 5)) & 0xFF);
  }

  public boolean fadeNext(Graphics graphics, int duration, int compareTime) {
    if (compareTime > duration) {
      fadeEffect.fadeIn(graphics, 1400, color(0, 0, 0, 0));

      if (fadeEffect.fadeInComplete) {
        part++;
        tick();
        return true;
      }
    } 
    else {
      fadeEffect.fadeOut(graphics, 1400, color(0, 0, 0, 255));
    }
    return false;
  }

  public boolean fadeNext(Graphics graphics, int duration, int compareTime, int fadeInLength, int fadeOutLength) {
    if (compareTime > duration) {
      fadeEffect.fadeIn(graphics, fadeInLength, color(0, 0, 0, 0));

      if (fadeEffect.fadeInComplete) {
        part++;
        tick();
        return true;
      }
    } 
    else {
      fadeEffect.fadeOut(graphics, fadeOutLength, color(0, 0, 0, 255));
    }
    return false;
  }

  public boolean fadeNext(Graphics graphics, int duration, int compareTime, int fadeInLength, int fadeOutLength, int fadeInColor, int fadeOutColor) {
    if (compareTime > duration) {
      fadeEffect.fadeIn(graphics, fadeInLength, fadeInColor);

      if (fadeEffect.fadeInComplete) {
        part++;
        tick();
        return true;
      }
    } 
    else {
      fadeEffect.fadeOut(graphics, fadeOutLength, fadeOutColor);
    }
    return false;
  }
}

