/*

 Name      :  Amigaball
 Notes     :  Bouncing red checkered ball.
 
 A tribute to the classic amiga bouncing ball demo.
 The 3D ball look comes from IQ's plane deformation effect with a seamless checker texture
 
 */
package demoplatform;

import demoplatform.GL.MathFP;
import java.awt.Color;
import java.awt.Graphics;

public class Amigaball extends Demoplatform {

  /* ball bounce vars */
  int ballSize;
  int rightBorder;       // hit right wall
  int ballRadius;
  int ballBase;
  int ball_x;
  int ball_y;            // ball position
  int ball_xv;
  int ball_yv = 0;       // ball velocity
  Deform amigaTexture;
  int[] textureImg;
  int pixelIndexLength;

  // constructor
  public Amigaball(int ww, int hh) {
    debug("Amigaball():: initialize");

    ballSize = 128;
    rightBorder = w - ballSize * 2;
    ballRadius = ballSize / 2;
    ballBase = h - ballSize * 2;
    ball_x = 0;
    ball_y = ballRadius;
    ball_xv = 2;
    ball_yv = 0;

    amigaTexture = new Deform("/images/amiga_checker.png", 11, 256, 256);
    pixelIndexLength = 256 * 256;
    amigaTexture.start();
    debug("Amigaball():: end initialize");
  }

  void drawBackground(Graphics g) {

    int segmentHeight = 20;
    int segmentWidth = 20;
    int sh;
    int sw;
    sh = h - segmentHeight;
    sw = w - segmentWidth;

    // draw grey background
    g.setColor(new Color(169, 169, 169));
    g.fillRect(0, 0, w, h);

    // pink lines
    g.setColor(new Color(0x9F, 0x40, 0x90));

    for (int x = segmentHeight; x < h; x += segmentHeight) {
      g.drawLine(segmentWidth, x, sw, x);
      g.drawLine(segmentWidth, x + 1, sw, x + 1);
    }

    for (int x = segmentHeight; x < w; x += segmentHeight) {
      g.drawLine(x, segmentHeight, x, sh);
      g.drawLine(x + 1, segmentHeight, x + 1, sh);
    }
  }

  void draw(int currentTime, int[] renderBuffer) {
    int timeDisplacement = (currentTime >> 3);

    for (int pixelIndex = 0; pixelIndex < pixelIndexLength; pixelIndex++) {

      int uu = amigaTexture.mLUTu[pixelIndex];
      int vv = amigaTexture.mLUTv[pixelIndex];
      int bb = amigaTexture.mLUTb[pixelIndex];
      int currentPixel = amigaTexture.tile_bitmap[((vv + timeDisplacement) + ((uu + timeDisplacement) << 7)) & 0x3FFF];

      if (!(uu > 0 || vv > 0)) {
        currentPixel = color(0, 0, 0, 0);
      }
      else
      {
        currentPixel = color(
        MathFP.clamp(bb + (currentPixel >> 16 & 0xFF), 0, 255), // equivalent to red(currentPixel);
        MathFP.clamp(bb + (currentPixel >> 8 & 0xFF), 0, 255), // equivalent to green(currentPixel);
        MathFP.clamp(bb + (currentPixel & 0xFF), 0, 255), // equivalent to blue(currentPixel);
        255 /// alpha
        );
      }
      renderBuffer[pixelIndex] = currentPixel;
    }

    // bounce the ball around
    ball_x += ball_xv;
    if ((ball_x < 1) || (ball_x > rightBorder)) {
      ball_xv = -ball_xv;
    }

    ball_y += ball_yv;
    if ((ball_yv > 0) && (ball_y > ballBase)) {
      ball_y = ballBase - (ball_y - ballBase);          // reflect in YBASE
      ball_yv = -ball_yv;                               // reverse Y velocity
    }
    ball_yv++;                                        // gravity
  }
}

