// Pixel shader input structure
struct PS_INPUT
{
    float4 Position   : VPOS;
    float2 Texture    : TEXCOORD0;
};


// Pixel shader output structure
struct PS_OUTPUT
{
    float4 Color   : COLOR0;
};


// Global variables

sampler2D Tex0;
sampler2D Tex1:register(s1);
sampler2D Tex2:register(s2);

float time;

float post_bloom;
float post_chromatic;
float post_fade;
float post_blur;

float post_fullscreen;
float post_fullscreen_scroll;

// Name: Simple Pixel Shader
// Type: Pixel shader
// Desc: Fetch texture and blend with constant color
//
float aspectRatio = 4/3;


#define FXAA_PC 1
#define FXAA_HLSL_3 1
#define FXAA_LINEAR 1
#include "Fxaa3_8.h"
  
  

PS_OUTPUT ps_main( in PS_INPUT In )
{
    PS_OUTPUT Out;                             //create an output pixel

	In.Texture.y = (In.Texture.y - 0.5) * ( (16.0/9.0) / aspectRatio ) + 0.5;
	if(In.Texture.y <= 0 || In.Texture.y >= 1) { 
		Out.Color = float4(0,0,0,1);
		return Out;
	}
	 
    float2 pos = In.Texture*2.0 - 1.0;
    
    //Out.Color = tex2D(Tex0, In.Texture);
    float2 rcpFrame = float2(1/1920.0,1/1080.0);
    Out.Color = FxaaPixelShader(In.Texture, float4(0,0,0,0) , Tex0, rcpFrame*2.0, float4(0,0,0,0));
    Out.Color.a = 1;
    
    
   
    Out.Color.rb *= 0.25;
    Out.Color.r += tex2D(Tex0, In.Texture + pos*0.002*post_chromatic).r*0.25;
    Out.Color.r += tex2D(Tex0, In.Texture + pos*0.004*post_chromatic).r*0.25;
    Out.Color.r += tex2D(Tex0, In.Texture + pos*0.008*post_chromatic).r*0.25;

    Out.Color.b += tex2D(Tex0, In.Texture - pos*0.002*post_chromatic).b*0.25;
    Out.Color.b += tex2D(Tex0, In.Texture - pos*0.004*post_chromatic).b*0.25;
    Out.Color.b += tex2D(Tex0, In.Texture - pos*0.008*post_chromatic).b*0.25;

	Out.Color.rgb = (1-post_blur) * Out.Color.rgb + post_blur*pow(0.5*pow(tex2Dlod(Tex0, float4(In.Texture*0.9 + 0.1*0.5,3,3)), 2.2) + 0.5*pow(tex2Dlod(Tex0, float4(In.Texture*0.95 + 0.05*0.5,2,2)), 2.2), 0.4545);

	Out.Color.rgb += pow(0.5*pow(tex2Dlod(Tex0, float4(In.Texture,6,6)), 2.2) + 0.5*pow(tex2Dlod(Tex0, float4(In.Texture,5,5)), 2.2), 8)*float3(0.4,0.5,0.8)*post_bloom;
	Out.Color.rgb = clamp(Out.Color.rgb, 0, 1);

    if(post_fullscreen > 1 && post_fullscreen < 2)
    	Out.Color.rgb = Out.Color.rgb * 0.2 + tex2D(Tex2, In.Texture*float2(1,0.675*0.5625)+float2(0, post_fullscreen_scroll) - Out.Color.rgb*0.00) * pow(1.1, post_bloom);
    else if(post_fullscreen > 1 && post_fullscreen < 3) {
		Out.Color.rgb = Out.Color.rgb * 0.00 + tex2D(Tex2, In.Texture*float2(1,0.675*0.5625)+float2(0, post_fullscreen_scroll) - Out.Color.rgb*0.00);
	}
	else if(post_fullscreen > 1) {
		Out.Color.rgb = Out.Color.rgb * 0.00 + tex2D(Tex2, In.Texture*float2(1*post_fullscreen_scroll,1*post_fullscreen_scroll)-float2(0, post_fullscreen_scroll*post_fullscreen_scroll) - Out.Color.rgb*0.00);
	}
    
	
	float x = 100 + (In.Position.x + 91) * (In.Position.y + 93) + (cos(time*3)*7+6);
	x = fmod(x, 13) * fmod(x, 123);	
	float dx = fmod(x, 0.02);

	float3 cResult = saturate(0.1f + dx.xxx * 50);
	Out.Color.rgb += Out.Color.brg*cResult*0.06 - 0.03;
	
    Out.Color.rgb = pow(pow(Out.Color, 2.2) * clamp(1.9 - length(pos), 0.0, 1.0), 1/2.2)-fmod(time*cos(time),0.03)*0.5;
    
    Out.Color.rgb *= post_fade;
    
    
    
    //Out.Color += float4(In.Texture, 0, 1);
    //Out.Color = float4(0.9f, 0.8f, 0.4, 1);   //do a simple effect
	
    return Out;                                //return output pixel
}