;TODO: check all the CLCs here
STAGGER equ     1               ;0 -> blocky pixels, 1 -> staggered, 21 "pixels" across (dither-ish)
YSTEP   equ     8
XVEL    equ     150
YVEL    equ     375

PlasmaKernel
    ldx #LINES/4-2
    sta WSYNC

    dec temp
    nop

KernelLoop
    clc
    lda ytab,X
    sta COLUBK
    jsr ramkernel

    SLEEP 5 - 2*STAGGER
    clc
    lda ytab,X
    sta COLUBK
    jsr ramkernel

#if STAGGER
    dec temp
    nop
#else
    SLEEP 5 + 2*STAGGER
#endif
    clc
    lda ytab,X
    sta COLUBK
    jsr ramkernel

    SLEEP 5 - 2*STAGGER
    clc
    lda ytab,X
    sta COLUBK
    jsr ramkernel

#if STAGGER
    nop
#endif
    dex
    bpl KernelLoop
#if >KernelLoop - >*
    echo "Plasma KernelLoop not aligned"
    ERR
#endif

    lda #0
    sta COLUBK

    sta WSYNC
    sta WSYNC
    sta WSYNC
    jmp KernelRet

PlasmaRAMKernel
DeltaBaseA equ * - PlasmaRAMKernel + ramkernel + 1
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    rts
KERNELSIZE  equ *-PlasmaRAMKernel

PlasmaLogic
    ;copy kernel to RAM
    ldx #KERNELSIZE-1
CopyKernel
    lda PlasmaRAMKernel,X
    sta ramkernel,X
    dex
    bpl CopyKernel

    lda xpos
    ;clc
    adc #<XVEL
    sta xpos
    lda xpos+1
    adc #>XVEL
    sta xpos+1

    lda ypos
    ;clc
    adc #<YVEL
    sta ypos
    lda ypos+1
    adc #>YVEL
    sta ypos+1


    ldx xpos+1
    lda SinTab,X
    lsr
    lsr
    lsr
    sta temp

    ;circular camera path
    ldx frame
    lda SinTab,X
    clc
    adc xpos+1
    tay

    ;plasma(X,Y) = 141 + f(X) + f(Y)
    ;f(Y) = 15.5 + sin(Y) * 15.5  (roughly)
    lda SinTab,Y    ;0..255
    lsr
    lsr
    lsr             ;0..31
    sta lastsample
    clc
    adc #141 - 32
    adc temp
    sta ytabofs

    ldx #0
    stx lastcarry   ;carry is clear when entering line kernel

    tya
    clc
    adc #YSTEP
    tay

LoadHorizClr
    lda SinTab,Y
    lsr
    lsr
    lsr
    sta temp        ;current sample

    sec
    sbc lastsample
    sec
    sbc lastcarry   ;account for carry shifting the value up by one
    sta DeltaBaseA,X

    ;set lastcarry if the operation would carry
    clc
    adc lastsample
    bcs Carries
    clc
    adc lastcarry
Carries
    lda #0
    adc #0
    sta lastcarry

    lda temp
    sta lastsample

    tya
    clc
    adc #YSTEP
    tay

    inx
    inx
    inx
    inx
    cpx #4*NHORISZCLR
    bcc LoadHorizClr

    lda frame
    clc
    adc #64
    tax
    lda SinTab,X
    clc
    adc ypos+1
    tay
    ldx #LINES/4-1

    lda measure
    cmp #PLASMAV2
    bcs LoadYtabV2

LoadYtab
    lda SinTab,Y
    lsr
    lsr
    lsr
    clc
    adc ytabofs
    sta ytab,X
    dey
    dex
    bpl LoadYtab
    bmi DoneLoadingYtab

LoadYtabV2
LoadYtabV2Loop
    lda SinTab,Y
    lsr
    lsr
    clc
    ;adc #16
    sta ytab,X
    dey
    dex
    bpl LoadYtabV2Loop
DoneLoadingYtab
    brk ;jmp LogicRet
