
#include "Constant.fx"
#include "ConstantBuffer.fx"
#include "HDR.fx"
#include "Deferred.fx"

struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
};

struct VSOut
{
	float4 Pos			: SV_POSITION;
	float2 Tex			: TEXCOORD0;
};

Texture2D	g_texInput;
Texture2D	g_bloomInput;
float		Exposure;

//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	OUT.Pos	= float4(IN.Pos.xyz,1);
    OUT.Tex	= IN.Tex.xy;

	return OUT;
}

//--------------------------------------------------------------------------------------
float3 Tonemap(float3 rgb)
{
	// Jim Hejl and Richard Burgess-Dawson operator		
	float3 x = max(0.0f,Exposure*rgb-0.004f);
	return (x*(6.2f*x+0.5f))/(x*(6.2f*x+15.0f)+0.06f);
}

//--------------------------------------------------------------------------------------
float4 PS(VSOut IN) : SV_TARGET0
{
	float3 rgb		= g_texInput.Sample(SamplerPointClamp, IN.Tex.xy ).rgb;

	float3 retColor = Tonemap(rgb);

	return float4(retColor,1);

}

//--------------------------------------------------------------------------------------
technique11 Tonemapper
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}

//--------------------------------------------------------------------------------------
float4 PSCaptureLuminance(VSOut IN) : SV_TARGET0
{
	float3 rgb = g_texInput.Sample(SamplerLinearClamp, IN.Tex.xy ).rgb;
	float lum = dot( rgb, float3(0.5,0.3,0.2) ); 
	return lum.xxxx;

}

//--------------------------------------------------------------------------------------
technique11 CaptureLuminance
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PSCaptureLuminance() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}

//-----------------------------------------------------------------------------
float DeltaTime;
float AdaptSpeed;
float AverageWanted;
float ExposureMax;
float ExposureMin;
Texture2D PreviousAdaptedLuminanceTexture;
Texture2D CurrentLuminanceTexture;

//-----------------------------------------------------------------------------
float4 PSAdaptLuminance(VSOut IN) : SV_TARGET0
{
	float previousLum = PreviousAdaptedLuminanceTexture.Sample(SamplerLinearClamp, float2(0.5, 0.5)).x;
	float currentLum = CurrentLuminanceTexture.Sample(SamplerLinearClamp, float2(0.5, 0.5)).x;
	float adaptedLum = previousLum + (currentLum - previousLum) * saturate(1 - exp(-DeltaTime * AdaptSpeed));
	float exposure = max(ExposureMin, min(ExposureMax, AverageWanted / adaptedLum));
	return float4(adaptedLum, exposure, 0, 0);
}

//--------------------------------------------------------------------------------------
technique11 AsaptLuminance
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PSAdaptLuminance() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}
