
#include "Constant.fx"

struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
}; 

struct VSOut
{
	float4 Pos			: SV_POSITION;
	float4 Tex			: TEXCOORD0;
};

struct PSIn
{
	float4 Pos			: SV_POSITION;
	float4 Tex			: TEXCOORD0;
};
  
struct PSOut
{ 
	float4 c0 : SV_TARGET0;	// worldpos.xyz, length(eyeVector)
	float4 c1 : SV_TARGET1;	// worldnorm.xyz, 1
	float4 c2 : SV_TARGET2;	// diffuse.rgba
	float4 c3 : SV_TARGET3;	// specular.rgb, glossiness
	float4 c4 : SV_TARGET4;	// selfillum.rgb, 1
	float4 c5 : SV_TARGET5;	// motion.xyz, 1
};  

TextureCube g_texture;

float4  g_XYWH = float4(0,0,1,1);
float4x4 g_InvViewProj;

//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

//	float2 xy = IN.Pos.xy * 0.5f + 0.5f; 
//	xy = g_XYWH.xy + xy * g_XYWH.zw; 
//	xy = xy * 2.0f - 1.0f;

	OUT.Pos	= float4(IN.Pos.xy, 1.0f, 1.0f);
	OUT.Tex = mul( float4(IN.Pos.xy, 1.0f, 1.0f), g_InvViewProj );	    
	OUT.Tex = OUT.Tex.xzyw;

	return OUT;
}

//--------------------------------------------------------------------------------------
PSOut PS(PSIn IN)
{
	PSOut OUT; 

	float4 pixel = g_texture.Sample(SamplerLinearWrap, IN.Tex.xyz );

	OUT.c0 = 0;
	OUT.c1 = 0;
	OUT.c2 = 0;
	OUT.c3 = 0;
	OUT.c4 = pixel;
	OUT.c5 = 0;

	return OUT;
}

//--------------------------------------------------------------------------------------
technique11 t0
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( EnableDepth, 0 );
    }
}
