#include "Constant.fx"
#include "ConstantBuffer.fx"
#include "HDR.fx"
#include "Deferred.fx"

struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
};

struct VSOut
{
	float4 Pos			: SV_POSITION;
	float2 Tex			: TEXCOORD0;
};

Texture2D	g_texInput;

//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	OUT.Pos	= float4(IN.Pos.xyz,1);
    OUT.Tex	= IN.Tex.xy;

	return OUT;
}

//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
float4 PS(VSOut IN) : SV_TARGET0
{
	GPixel gbuffer = FetchGBuffer(IN.Tex.xy);

	float stepCount = 32;
	float2 step = gbuffer.MotionVector / stepCount;
	float3 rgb = 0;
	float2 tex = IN.Tex.xy;
	float w = 1.0f;
	float total = 0;
	for (int i=0; i<stepCount; i++)
	{
		rgb += g_texInput.Sample(SamplerLinearClamp, tex ).rgb * w;
		tex += step;
		total += w;
		w *= 0.9f;
	}
	rgb /= total;

//	rgb = normalize( float3( gbuffer.MotionVector.xy, 0 ) );

	return float4(rgb, 1);
}

//--------------------------------------------------------------------------------------
technique11 MotionBlur
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}