//--------------------------------------------------------------------------------------
#include "Constant.fx"

//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D txDiffuse;

struct VS_INPUT
{
    float4 Pos		: POSITION;
    float3 Norm		: NORMAL;
    float3 Tan		: TANGENT;
    float3 Bin		: BINORMAL;
    float2 Tex		: TEXCOORD;
};

struct PS_INPUT
{
    float4 Pos			: SV_POSITION;
    float2 Tex			: TEXCOORD0;
    float3 WorldNorm	: TEXCOORD1;
    float3 WorldTan		: TEXCOORD2;
    float3 WorldBin		: TEXCOORD3;
	float3 WorldPos		: TEXCOORD4;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output = (PS_INPUT)0;
	
	output.Pos	= mul(input.Pos, WorldViewProj);
    output.Tex	= input.Tex;

	float3 WorldNorm	= normalize( mul(input.Norm, (float3x3) World) );
	float3 WorldTan		= normalize( mul(input.Tan, (float3x3) World) );
	float3 WorldBin		= normalize( mul(input.Bin, (float3x3) World) );
	float3 WorldPos		= mul(input.Pos, World);

	output.WorldNorm	= WorldNorm;
	output.WorldTan		= WorldTan;
	output.WorldBin		= WorldBin;
	output.WorldPos		= WorldPos;
   
    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( PS_INPUT input) : SV_Target
{

	float3 Kd = txDiffuse.Sample( SamplerLinearWrap, input.Tex );
	float3 EyeVec = normalize( EyePos - input.WorldPos );
	float3 WorldNorm = normalize( input.WorldNorm ); 

	return float4(WorldNorm * 0.5f + 0.5f, 1);

	float3 f = 0;

// 	for ( int i=0; i<OmniCount.x; i++)
// 	{
// 		float3 LightVec = OmniPosAttn[i].xyz - input.WorldPos;
// 		float Distance = length(LightVec);
// 		LightVec /= Distance;
// 
// 		float3 HalfVec = (LightVec + EyeVec) * 0.5;
// 
// 		float ndl = saturate( dot( LightVec, WorldNorm ) );
// 		float ndh = saturate( dot( HalfVec, WorldNorm ) );  
// 		float Attn = 1.0f - saturate( Distance * OmniPosAttn[i].w );
// 		
// 
// 		f += Kd * ndl * OmniColor[i] * Attn;
// 		f += pow(ndh,24) * OmniColor[i] * Attn;
// 	}
// 
	return float4(f, 1);
}


//--------------------------------------------------------------------------------------
technique11 Render
{
    pass P0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
    }
}
