
float3 GammaToLinear(float3 rgb)
{
	return pow(abs(rgb), 2.2f);
}

float3 LinearToGamma(float3 rgb)
{
	return pow(abs(rgb), 1.0f / 2.2f);
}

// From Uncharted 2 GDC slides.
float3 Tonemap(float3 x, float exposure)
{
	float A = 0.15;
	float B = 0.50;
	float C = 0.10;
	float D = 0.20;
	float E = 0.02;
	float F = 0.30;
	float W = 11.2;

	x *= exposure;

	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}
