//--------------------------------------------------------------------------------------
// 07.05.2010 GW
#include "Constant.fx"

//--------------------------------------------------------------------------------------
struct VSIn
{
    float4 Pos		: POSITION;
	float2 Tex		: TEXCOORD0;
	float4 Col		: TEXCOORD1;
};

struct VSOut
{ 
	float4 Pos		: SV_POSITION;
	float2 Tex		: TEXCOORD0;
	float4 Col		: TEXCOORD1;
};

struct PSOut
{
	float4 c0 : SV_TARGET0;	
};

float4 g_viewportSize;
Texture2D g_texture;

//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	float2 xy = IN.Pos.xy;
	xy = xy / g_viewportSize.xy;
	xy = xy * 2.0f - 1.0f;
	xy.y = -xy.y;


	OUT.Pos	= float4(xy, IN.Pos.z, 1);
    OUT.Col = IN.Col;
	OUT.Tex	= IN.Tex;

	return OUT;
}

//--------------------------------------------------------------------------------------
PSOut PS(VSOut IN)
{
	PSOut OUT;	
	OUT.c0.rgb = IN.Col.rgb * IN.Col.a;
	OUT.c0.a = IN.Col.a;
	return OUT;
}

//--------------------------------------------------------------------------------------
PSOut PSTexture(VSOut IN)
{
	PSOut OUT;	
	float4 tex = g_texture.SampleLevel(SamplerLinearClamp, IN.Tex, 0);
	OUT.c0 = tex * IN.Col;
	OUT.c0.rgb *= OUT.c0.a;

	return OUT;
}

//--------------------------------------------------------------------------------------
technique11 techLine
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetDepthStencilState(EnableDepth, 0);
		SetBlendState(PreMultAlphaBlending, float4(0,0,0,0), 0xffffffff);
		SetRasterizerState(Wireframe);
    }
}

//--------------------------------------------------------------------------------------
technique11 techFilled
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetDepthStencilState(EnableDepth, 0);
		SetBlendState(PreMultAlphaBlending, float4(0,0,0,0), 0xffffffff);
		SetRasterizerState(CullNone);
    }
}

//--------------------------------------------------------------------------------------
technique11 techTextured
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PSTexture() ) );
		SetDepthStencilState(EnableDepth, 0);
		SetBlendState(PreMultAlphaBlending, float4(0,0,0,0), 0xffffffff);
		SetRasterizerState(CullNone);
    }
}
