
//--------------------------------------------------------------------------------------
PSOut PSGBuffer(VSOut IN)
{
	PSOut OUT;

	GBufferOut gb;
	gb.WorldNorm	= TangentToWorld( float3(0,0,1), IN );
	gb.Diffuse		= float3(1,1,1);
	gb.Specular		= float3(1,1,1);
	gb.Glossiness	= 64.0f;
	gb.SelfIllum	= float3(0,0,0);
	gb.Ksss			= 0;

	PS(IN,gb);
	
	OUT.c0 = float4(IN.WorldPos, length(IN.ViewPos));
	OUT.c1 = float4(gb.WorldNorm, gb.Ksss);
	OUT.c2 = float4(gb.Diffuse.xyz, 1.0f); 
	OUT.c3 = float4(gb.Specular, gb.Glossiness); 
	OUT.c4 = float4(gb.SelfIllum, 1.0f); 
	OUT.c5 = float4(IN.MotionDelta.xy,1,1);

	return OUT;
}

struct HS_ConstantOutput
{
    float TessFactor[3]    : SV_TessFactor;
    float InsideTessFactor : SV_InsideTessFactor;

	float3 f3B210   : POSITION3;
    float3 f3B120   : POSITION4;
    float3 f3B021   : POSITION5;
    float3 f3B012   : POSITION6;
    float3 f3B102   : POSITION7;
    float3 f3B201   : POSITION8;
    float3 f3B111   : CENTER;

};

HS_ConstantOutput HS_TrianglesConstant( InputPatch<VSOut, 3> IN )
{
    HS_ConstantOutput OUT = (HS_ConstantOutput)0;

	OUT.TessFactor[0] = 64;
	OUT.TessFactor[1] = 64;
	OUT.TessFactor[2] = 64;

// 	[unroll]
// 	for (unsigned int i=0; i<3; i++)
// 	{
// 		float3 edge = IN[(i + 1) % 3].Pos.xyz - IN[i].Pos.xyz;
// 		float3 vec = (IN[(i + 1) % 3].Pos.xyz + IN[i].Pos.xyz) / 2 - EyePos.xyz;
// 		float len = sqrt(dot(edge, edge) / dot(vec, vec));
// 		OUT.TessFactor[(i + 1) % 3] = max(1, len * 16.0f);
// 	}

    OUT.InsideTessFactor = (OUT.TessFactor[0] + OUT.TessFactor[1] + OUT.TessFactor[2]) / 3;

	float3 p0 = IN[0].Pos.xyz;
	float3 p1 = IN[1].Pos.xyz;
	float3 p2 = IN[2].Pos.xyz;

	float3 n0 = IN[0].Normal;
	float3 n1 = IN[1].Normal;
	float3 n2 = IN[2].Normal;

	OUT.f3B210 = ( ( 2.0f * p0 ) + p1 - ( dot( ( p1 - p0 ), n0 ) * n0 ) ) / 3.0f;
	OUT.f3B120 = ( ( 2.0f * p1 ) + p0 - ( dot( ( p0 - p1 ), n1 ) * n1 ) ) / 3.0f;
	OUT.f3B021 = ( ( 2.0f * p1 ) + p2 - ( dot( ( p2 - p1 ), n1 ) * n1 ) ) / 3.0f;
	OUT.f3B012 = ( ( 2.0f * p2 ) + p1 - ( dot( ( p1 - p2 ), n2 ) * n2 ) ) / 3.0f;
	OUT.f3B102 = ( ( 2.0f * p2 ) + p0 - ( dot( ( p0 - p2 ), n2 ) * n2 ) ) / 3.0f;
	OUT.f3B201 = ( ( 2.0f * p0 ) + p2 - ( dot( ( p2 - p0 ), n0 ) * n0 ) ) / 3.0f;
	// center control point
	float3 f3E = ( OUT.f3B210 + OUT.f3B120 + OUT.f3B021 + OUT.f3B012 + OUT.f3B102 + OUT.f3B201 ) / 6.0f;
	float3 f3V = ( p0 + p1 + p2 ) / 3.0f;
	OUT.f3B111 = f3E + ( ( f3E - f3V ) / 2.0f );

    return OUT;
}

[domain("tri")]
[partitioning("integer")]
[outputtopology("triangle_cw")]
[patchconstantfunc("HS_TrianglesConstant")]
[outputcontrolpoints(3)]
[maxtessfactor(64.0)]
VSOut HS_Triangles_integer( InputPatch<VSOut, 3> IN, uint i : SV_OutputControlPointID )
{
    return IN[i];    
}

[domain("tri")]
VSOut DS_Triangles( HS_ConstantOutput HSConstantData, const OutputPatch<VSOut, 3> IN, float3 f3BarycentricCoords : SV_DomainLocation )
{
    VSOut O = (VSOut)IN[0];

    // The barycentric coordinates
    float fU = f3BarycentricCoords.x;
    float fV = f3BarycentricCoords.y;
    float fW = f3BarycentricCoords.z;

	// O.Pos = I[0].Pos * fW + I[1].Pos * fU + I[2].Pos * fV;

	// Precompute squares and squares * 3 
    float fUU = fU * fU;
    float fVV = fV * fV;
    float fWW = fW * fW;
    float fUU3 = fUU * 3.0f;
    float fVV3 = fVV * 3.0f;
    float fWW3 = fWW * 3.0f;

    // Compute position from cubic control points and barycentric coords
    float3 pos = IN[0].Pos.xyz * fWW * fW + IN[1].Pos.xyz * fUU * fU + IN[2].Pos.xyz * fVV * fV +
					  HSConstantData.f3B210 * fWW3 * fU + HSConstantData.f3B120 * fW * fUU3 + HSConstantData.f3B201 * fWW3 * fV + HSConstantData.f3B021 * fUU3 * fV +
					  HSConstantData.f3B102 * fW * fVV3 + HSConstantData.f3B012 * fU * fVV3 + HSConstantData.f3B111 * 6.0f * fW * fU * fV;

#define _INTERPOL(_m)	O._m = IN[0]._m * fW + IN[1]._m * fU + IN[2]._m * fV 

	_INTERPOL(Tex); 
	_INTERPOL(WorldPos); 
	_INTERPOL(WorldNorm); 
	_INTERPOL(WorldTan); 
	_INTERPOL(WorldBin); 
	_INTERPOL(ViewPos); 
	_INTERPOL(MotionDelta); 
	_INTERPOL(Normal); 


#ifdef DISPLACEMENT_ENABLE

	float disp = Displacement.SampleLevel( SamplerLinearWrap, O.Tex.xy, 0).r;
	pos += O.Normal * disp * DisplacementDistance;

#endif // DISPLACEMENT_ENABLE

	float4 WorldPos		= mul(float4(pos.xyz, 1.0f), World);
	float4 ViewPos		= mul(WorldPos, View);
	float4 ProjPos		= mul(ViewPos, Proj);
	O.Pos = ProjPos;


    return O;
}

//--------------------------------------------------------------------------------------
technique11 t0
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS(false) ) );        
        SetPixelShader( CompileShader( ps_4_0, PSGBuffer() ) );
// 		SetHullShader( CompileShader( hs_5_0, HS_Triangles_integer() ) );
// 		SetDomainShader( CompileShader( ds_5_0, DS_Triangles() ) );
		SetDepthStencilState(EnableDepth, 0);
		SetBlendState(DefaultBlending, float4(0,0,0,0), 0xffffffff);
//		SetRasterizerState(Wireframe);
		SetRasterizerState(CullBack);
    }
}

//--------------------------------------------------------------------------------------
technique11 t1
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS(true) ) );        
        SetPixelShader( CompileShader( ps_4_0, PSGBuffer() ) );
//  		SetHullShader( CompileShader( hs_5_0, HS_Triangles_integer() ) );
//  		SetDomainShader( CompileShader( ds_5_0, DS_Triangles() ) );
		SetDepthStencilState(EnableDepth, 0);
		SetBlendState(DefaultBlending, float4(0,0,0,0), 0xffffffff);
		SetRasterizerState(Wireframe);
		SetRasterizerState(CullBack);
    }
}