#include "Constant.fx"
#include "ConstantBuffer.fx"

struct VSIn  
{ 
    float4 Pos		: POSITION;
    float3 Norm		: NORMAL;
    float3 Tan		: TANGENT;
    float3 Bin		: BINORMAL;
    float2 Tex0		: TEXCOORD0;
    float2 Tex1		: TEXCOORD1;
};
 
struct VSOut 
{ 
	float4 Pos			: SV_POSITION;
	float4 Tex			: TEXCOORD0;
	float3 WorldPos		: TEXCOORD1; 
	float3 WorldNorm	: TEXCOORD2;
	float3 WorldTan		: TEXCOORD3;
	float3 WorldBin		: TEXCOORD4;	
	float3 ViewPos		: TEXCOORD5;
	float2 MotionDelta	: TEXCOORD6;
	float3 Normal		: TEXCOORD7;
}; 

struct PSOut
{ 
	float4 c0 : SV_TARGET0;	// worldpos.xyz, length(eyeVector)
	float4 c1 : SV_TARGET1;	// worldnorm.xyz, 1
	float4 c2 : SV_TARGET2;	// diffuse.rgba
	float4 c3 : SV_TARGET3;	// specular.rgb, glossiness
	float4 c4 : SV_TARGET4;	// selfillum.rgb, 1
	float4 c5 : SV_TARGET5;	// motion.xyz, 1
};

struct GBufferOut
{
	float3	WorldNorm;
	float3	Diffuse;
	float3	Specular;
	float	Glossiness;
	float3	SelfIllum;
	float	Ksss;
};

//--------------------------------------------------------------------------------------
float2 ToScreenSpace(float2 p)
{
	p = p * 2 - 1;
	p.y *= -1;
	return p;
}
//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN, uniform bool displace)
{
	VSOut OUT;
 
	float4 WorldPos		= mul(IN.Pos, World);
	float4 ViewPos		= mul(WorldPos, View);
	float4 ProjPos		= mul(ViewPos, Proj);

 	float4 WorldPosPrev	= mul(IN.Pos, WorldPrev);
 	float4 ViewPosPrev	= mul(WorldPosPrev, ViewPrev);
 	float4 ProjPosPrev	= mul(ViewPosPrev, Proj);

    OUT.Tex	= IN.Tex0.xyxy;

	float3 WorldNorm	= normalize( mul(IN.Norm.xyz, (float3x3)World) ).xyz;
	float3 WorldTan		= normalize( mul(IN.Tan.xyz, (float3x3)World) ).xyz;
	float3 WorldBin		= normalize( mul(IN.Bin.xyz, (float3x3)World) ).xyz;
	
	OUT.WorldNorm		= WorldNorm;
	OUT.WorldTan		= WorldTan;
	OUT.WorldBin		= WorldBin;

	float2 MotionDelta = ToScreenSpace(ProjPos.xy / ProjPos.w) - ToScreenSpace(ProjPosPrev.xy / ProjPosPrev.w);

	float3 MotionVector = WorldPosPrev.xyz - WorldPos.xyz;
 	float d = dot( MotionVector, WorldNorm ); 
 	if (d < 0.0f)
	{
		OUT.WorldPos	= WorldPos.xyz;
		OUT.ViewPos		= ViewPos.xyz;
		OUT.Pos			= ProjPos;
	}
  	else
  	{
  		OUT.WorldPos	= WorldPosPrev.xyz;
  		OUT.ViewPos		= ViewPosPrev.xyz;
 		OUT.Pos			= ProjPosPrev;
 	}

	OUT.MotionDelta = MotionDelta; //  * MotionBlurDelay.xx;

	if (displace)
		OUT.Pos = IN.Pos;

	OUT.Normal = IN.Norm.xyz;

	return OUT;
}

//--------------------------------------------------------------------------------------
float3 TangentToWorld(float3 v, VSOut IN)
{
	float3x3 basis = 
	{
		normalize(IN.WorldTan),			
		normalize(IN.WorldBin),			
		normalize(IN.WorldNorm)			
	};
	return mul(v, basis);
}

//--------------------------------------------------------------------------------------
float3 WorldToTangent(float3 v, VSOut IN)
{
	float3x3 basis = 
	{
		normalize(IN.WorldTan),			
		normalize(IN.WorldBin),			
		normalize(IN.WorldNorm)			
	};
	return mul(basis, v);
}
