//--------------------------------------------------------------------------------------
// 18/04/2010 Guillaume

#include "Constant.fx"

//--------------------------------------------------------------------------------------
struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
	float4 Color	: COLOR;
};

//--------------------------------------------------------------------------------------
struct VSOut
{
	float4 Pos		: SV_POSITION;
	float2 Tex		: TEXCOORD0;
	float4 Color	: TEXCOORD1;
};

//--------------------------------------------------------------------------------------
Texture2D g_fontTexture;
float4 g_viewportSize;
float4 g_fontTextureSize;
row_major matrix g_xform;
	
//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	float2 xy = mul( float4(IN.Pos.xy,0,1), g_xform ).xy;
	xy = xy / g_viewportSize.xy;
	xy = xy * 2.0f - 1.0f;
	xy.y = -xy.y;
	
	OUT.Pos	= float4(xy,IN.Pos.z,1);
	OUT.Tex = IN.Tex / g_fontTextureSize.xy;
	OUT.Color = IN.Color;

	return OUT;
}

//--------------------------------------------------------------------------------------
float4 PS(VSOut IN) : SV_TARGET0
{
	float f = g_fontTexture.Sample(SamplerLinearWrap, IN.Tex.xy).r;		
	float4 OUT = IN.Color;
	OUT.rgb *= f;
	OUT.a = f;
	return OUT;
}

//--------------------------------------------------------------------------------------
technique11 t0
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetRasterizerState( CullNone );
		SetBlendState( PreMultAlphaBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( EnableDepth, 0 );
    }
}
