
#include "ConstantBuffer.fx"
#include "Constant.fx"
#include "HDR.fx"
#include "Deferred.fx"

//--------------------------------------------------------------------------------------
struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
};

//--------------------------------------------------------------------------------------
struct VSOut
{
	float4 Pos			: SV_POSITION;
	float2 Tex			: TEXCOORD0;
};

//--------------------------------------------------------------------------------------
Texture2D g_texInput;
float FogBottom;
float FogInvHeight;
float FogStart;
float FogRangeInv;
float FogOpacity;
float FogHeightOpacity;
float3 FogColor;
float3 FogHeightColor;
float FogHeightEyeBias;

//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	OUT.Pos	= float4(IN.Pos.xyz,1);
    OUT.Tex	= IN.Tex.xy;

	return OUT;
}

//--------------------------------------------------------------------------------------
float4 PS(VSOut IN) : SV_TARGET0
{
	float3 rgb = g_texInput.Sample(SamplerPointClamp, IN.Tex.xy ).rgb;
	GPixel g = FetchGBuffer(IN.Tex.xy);
	float3 worldPos = g.WorldPos.xyz;

	float d = max(0, getViewSpaceZ(IN.Tex.xy) - FogStart);
	float e = 1.0f - saturate( exp(-d * FogRangeInv) );

	float dh = max(0, worldPos.z - FogBottom);
	float eh = saturate( exp(-dh * FogInvHeight) );

	rgb = lerp( rgb, FogColor, e * FogOpacity ); 
	rgb = lerp( rgb, FogHeightColor, max(eh,FogHeightEyeBias) * FogHeightOpacity ); 
	return float4( rgb, 1 );

}

//--------------------------------------------------------------------------------------
technique11 FogExp
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}