//--------------------------------------------------------------------------------------
// 18/04/2010 Guillaume

#include "Constant.fx"

//--------------------------------------------------------------------------------------
struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
};

//--------------------------------------------------------------------------------------
struct VSOut
{ 
	float4 Pos			: SV_POSITION;
};

//--------------------------------------------------------------------------------------
StructuredBuffer<float4> g_buffer;
uint4 g_textureSize;
	   
//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	float xy = IN.Pos.xy * 0.5f + 0.5f;
	xy = g_XYWH.xy + xy * g_XYWH.zw;
	xy = xy * 2.0f - 1.0f;

	OUT.Pos	= float4(IN.Pos.xy,0,1);

	return OUT;
}

//--------------------------------------------------------------------------------------
float4 PS(VSOut IN) : SV_TARGET0
{
	float4 pixel = buffer[ (IN.Pos.x - 0.5) + (IN.Pos.y - 0.5) * g_textureSize.x ];
	return pixel;
}

//--------------------------------------------------------------------------------------
technique11 t0
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}
