// 01.10.2011

#include "Constant.fx"
#include "ConstantBuffer.fx"
#include "HDR.fx"
#include "Deferred.fx"

struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
};

struct VSOut
{
	float4 Pos			: SV_POSITION;
	float2 Tex			: TEXCOORD0;
};

//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	OUT.Pos	= float4(IN.Pos.xyz,1);
    OUT.Tex	= IN.Tex.xy;

	return OUT;
}

Texture2D	g_texDepth;
Texture2D	g_texInput;
float DofNearStart;
float DofNearOODelta;	// 1.0f / (end - start)
float DofFarStart;
float DofFarOODelta;	// 1.0f / (end - start)
float4 g_cameraNearFar;
float BlurRadius;

//--------------------------------------------------------------------------------------
float4 PSRenderDepthCoC(VSOut IN) : SV_TARGET0
{
	float z = g_texDepth.Sample(SamplerPointClamp, IN.Tex.xy).r;

	float cameraFar				= g_cameraNearFar.y;
	float cameraNearFar			= g_cameraNearFar.z;
	float cameraFarMinusNear	= g_cameraNearFar.w;

	float viewSpaceZ = -(cameraNearFar / (z * cameraFarMinusNear - cameraFar));
	float dofNear = 1.0f - saturate( (viewSpaceZ-DofNearStart) * DofNearOODelta );
	float dofFar = saturate( (viewSpaceZ-DofFarStart) * DofFarOODelta );
	float dof = saturate(dofNear + dofFar);
	
	return float4(viewSpaceZ, dof, 0, 0);
}

//--------------------------------------------------------------------------------------
float4 DoCoCSpread(float2 Tex, bool horizontal)
{
	float4 currentTap = g_texInput.Sample(SamplerPointClamp, Tex.xy);
	float depth = currentTap.x;
	float blur = currentTap.y;

	float outputBlur = blur;
	float totalContribution = 1;

	int BlurStep = 7;

	for (int x=-BlurStep; x<=BlurStep; x++)
	{
		float2 offset		= horizontal ? float2(x*BlurRadius,0) : float2(0,x*BlurRadius);
		float4 tap			= g_texInput.Sample(SamplerPointClamp, Tex.xy + offset);

		float tapDepth		= tap.x;
		float tapBlur		= tap.y;

		float depthWeight		= tapDepth <= depth;
		float blurWeight		= saturate(tapBlur - blur);
		float tapContribution	= depthWeight * blurWeight;

		outputBlur += tapBlur * tapContribution;		
		totalContribution += tapContribution;
	}

	return float4(depth, outputBlur / totalContribution, 0, 0);
}

//--------------------------------------------------------------------------------------
float4 PSCoCSpreadH(VSOut IN) : SV_TARGET0
{
	return DoCoCSpread(IN.Tex, true);
}

//--------------------------------------------------------------------------------------
float4 PSCoCSpreadV(VSOut IN) : SV_TARGET0
{
	return DoCoCSpread(IN.Tex, false);
}

//--------------------------------------------------------------------------------------
float4 PSDebug(VSOut IN) : SV_TARGET0
{
	float4 p = g_texInput.Sample(SamplerLinearClamp, IN.Tex.xy);
	return p.yyyy;
}

Texture2D g_texDepthCoC;

//--------------------------------------------------------------------------------------
float4 Dof(float2 Tex, bool horizontal)
{
	float4 color = g_texInput.Sample(SamplerPointClamp, Tex);
	float4 depthNearCoc = g_texDepthCoC.Sample(SamplerPointClamp, Tex);
	float depth = depthNearCoc.x;
	float coc = depthNearCoc.y;

	float4 outputColor = color;
	float totalContribution = 1;

	int BlurStep = 7;
	float cocSize = BlurStep * coc;

	for (int x=-BlurStep; x<=BlurStep; x++)
	{
		float2 offset		= horizontal ? float2(x*BlurRadius,0) : float2(0,x*BlurRadius);
		float4 tap			= g_texDepthCoC.Sample(SamplerPointClamp, Tex.xy + offset);
		float4 tapColor		= g_texInput.Sample(SamplerLinearClamp, Tex.xy + offset);
		float tapDepth		= tap.x;
		float tapBlur		= tap.y;

		float cocWeight		= saturate( cocSize + 1 - abs(x) );
		float depthWeight	= tapDepth >= depth;
		float blurWeight	= tapBlur;
		float tapWeight		= cocWeight * saturate( depthWeight + blurWeight );

		outputColor += tapColor * tapWeight;
		totalContribution += tapWeight;
	}

	return outputColor / totalContribution;
}

//--------------------------------------------------------------------------------------
float4 PSDofH(VSOut IN) : SV_TARGET0
{
	return Dof(IN.Tex, true);
}

//--------------------------------------------------------------------------------------
float4 PSDofV(VSOut IN) : SV_TARGET0
{
	return Dof(IN.Tex, false);
}

//--------------------------------------------------------------------------------------
technique11 RenderDepthCoC
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PSRenderDepthCoC() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}

//--------------------------------------------------------------------------------------
technique11 CoCSpreadH
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PSCoCSpreadH() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}

//--------------------------------------------------------------------------------------
technique11 CoCSpreadV
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PSCoCSpreadV() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}


//--------------------------------------------------------------------------------------
technique11 DofDebug
{
    pass p0     
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PSDebug() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}

//--------------------------------------------------------------------------------------
technique11 DofH
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PSDofH() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}

//--------------------------------------------------------------------------------------
technique11 DofV
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PSDofV() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}