
#include "Constant.fx"

struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
};

struct VSOut
{
	float4 Pos			: SV_POSITION;
	float4 Tex			: TEXCOORD0;
};

struct PSIn
{
	float4 Pos			: SV_POSITION;
	float4 Tex			: TEXCOORD0;
};

struct PSOut
{
	float4 c0 : SV_TARGET0;
};

Texture2DArray g_texGBuffer;

//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;
	OUT.Pos	= float4(IN.Pos.xyz,1);
    OUT.Tex	= IN.Tex.xyxy;
	return OUT;
}

//--------------------------------------------------------------------------------------
PSOut PS(PSIn IN)
{
	PSOut OUT;
	float2 uv = IN.Tex.xy * 4;
	OUT.c0 = g_texGBuffer.Sample(SamplerLinearWrap,float3(frac(uv), floor(uv.x) ));
	return OUT;
}


//--------------------------------------------------------------------------------------
technique11 t0
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetDepthStencilState( DisableDepth, 0 );
		SetRasterizerState( CullNone );
		SetBlendState(DefaultBlending, float4(0,0,0,0), 0x0ffffffff);
    }
}
