Texture2DArray g_texGBuffer;
Texture2D g_texDepthBuffer;

#define DEF_SLOT_WORLDPOS	0
#define DEF_SLOT_WORLDNORM	1
#define DEF_SLOT_KD			2
#define DEF_SLOT_KS			3
#define DEF_SLOT_SELFILLUM	4
#define DEF_SLOT_MOTIONBLUR	5

struct GPixel
{
	float4 WorldPos;
	float3 WorldNorm;
	float4 Kd;
	float4 Ks;
	float4 SelfIllum;
	float2 MotionVector;
	float  Ksss;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
float getViewSpaceZ(float2 uv)
{
 	float cameraFar	= CameraNearFar.y;
 	float cameraNearFar	= CameraNearFar.z;
 	float cameraFarMinusNear = CameraNearFar.w;
	float z = g_texDepthBuffer.Sample(SamplerPointClamp, uv).r;
 	float viewSpaceZ = -(cameraNearFar / (z * cameraFarMinusNear - cameraFar));
	return viewSpaceZ;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
GPixel FetchGBuffer(float2 uv)
{
	GPixel p;

	//p.WorldPos	= g_texGBuffer.Sample(SamplerPointClamp, float3(uv,DEF_SLOT_WORLDPOS) );

	float4 f		= g_texGBuffer.Sample(SamplerPointClamp, float3(uv,DEF_SLOT_WORLDNORM) );
	p.WorldNorm		= normalize(f.xyz * 2 - 1);
	p.Ksss			= f.w;

	p.Kd			= g_texGBuffer.Sample(SamplerPointClamp, float3(uv,DEF_SLOT_KD) );
	p.Ks			= g_texGBuffer.Sample(SamplerPointClamp, float3(uv,DEF_SLOT_KS) );
	p.Ks.a *= 1024;
	p.SelfIllum		= g_texGBuffer.Sample(SamplerPointClamp, float3(uv,DEF_SLOT_SELFILLUM) );
	p.MotionVector	= g_texGBuffer.Sample(SamplerPointClamp, float3(uv,DEF_SLOT_MOTIONBLUR) ).xy;

	p.Kd.rgb		= GammaToLinear(p.Kd.rgb);
	p.SelfIllum.rgb = GammaToLinear(p.SelfIllum.rgb);


	float2 screenXY	= (uv * 2.0f - 1.0f) * float2(1.0f, -1.0f);
	float2 proj		= float2(1.0f/Proj[0].x, 1.0f/Proj[1].y);
	float3 viewDir	= float3(-screenXY * proj, 1.0f);
	viewDir = mul(viewDir, (float3x3)InvView); 

	float3 eyeToPos = viewDir.xyz * (-getViewSpaceZ(uv));
 	float4 WorldPos = float4(EyePos.xyz + eyeToPos, 1.0f);
	p.WorldPos		= WorldPos;


	return p;
}